/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven_executions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.StringUtils;
import org_scala_tools_maven_executions.JavaMainCaller;

public abstract class JavaMainCallerSupport
implements JavaMainCaller {
    protected AbstractMojo requester;
    protected List<String> env = new ArrayList<String>();
    protected String mainClassName;
    protected List<String> jvmArgs = new ArrayList<String>();
    protected List<String> args = new ArrayList<String>();

    protected JavaMainCallerSupport(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args) throws Exception {
        this.requester = requester;
        for (String key : System.getenv().keySet()) {
            this.env.add(key + "=" + System.getenv(key));
        }
        this.mainClassName = mainClassName;
        this.addJvmArgs("-classpath", classpath);
        this.addJvmArgs(jvmArgs);
        this.addArgs(args);
    }

    public void addJvmArgs(String ... args) {
        if (args != null) {
            for (String arg : args) {
                if (!StringUtils.isNotEmpty((String)arg)) continue;
                this.jvmArgs.add(arg);
            }
        }
    }

    public void addToClasspath(File entry) throws Exception {
        if (entry == null || !entry.exists()) {
            return;
        }
        boolean isClasspath = false;
        for (int i = 0; i < this.jvmArgs.size(); ++i) {
            String item = this.jvmArgs.get(i);
            if (isClasspath) {
                item = item + File.pathSeparator + entry.getCanonicalPath();
                this.jvmArgs.set(i, item);
                isClasspath = false;
                break;
            }
            isClasspath = "-classpath".equals(item);
        }
    }

    public void addOption(String key, String value) {
        if (StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)key)) {
            return;
        }
        this.addArgs(key, value);
    }

    public void addOption(String key, File value) {
        if (value == null || StringUtils.isEmpty((String)key)) {
            return;
        }
        this.addArgs(key, value.getAbsolutePath());
    }

    public void addOption(String key, boolean value) {
        if (!value || StringUtils.isEmpty((String)key)) {
            return;
        }
        this.addArgs(key);
    }

    public void addArgs(String ... args) {
        if (args != null) {
            for (String arg : args) {
                if (!StringUtils.isNotEmpty((String)arg)) continue;
                this.args.add(arg);
            }
        }
    }

    public void addEnvVar(String key, String value) {
        this.env.add(key + "=" + value);
    }

    public void run(boolean displayCmd) throws Exception {
        this.run(displayCmd, true);
    }
}

