/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.specimpl;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.resteasy.specimpl.MultivaluedMapImpl;
import org.resteasy.specimpl.PathSegmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriInfoImpl
implements UriInfo {
    private String path;
    private String encodedPath;
    private MultivaluedMap<String, String> queryParameters;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> templateParameters;
    private MultivaluedMap<String, String> encodedTemplateParameters;
    private List<PathSegment> pathSegments;
    private List<PathSegment> encodedPathSegments;
    private URI absolutePath;
    private URI absolutePathWithQueryString;
    private URI baseURI;
    private String queryString;
    private List<String> ancestorUris;
    private List<String> encodedAncestorUris;
    private List<Object> ancestors;

    public UriInfoImpl(URI absolutePath, String path, String queryString) {
        this(absolutePath, path, queryString, PathSegmentImpl.parseSegments(path));
    }

    public UriInfoImpl(URI absolutePath, String encodedPath, String queryString, List<PathSegment> encodedPathSegments) {
        this.encodedPath = encodedPath;
        try {
            this.path = URLDecoder.decode(encodedPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.absolutePath = absolutePath;
        this.queryParameters = new MultivaluedMapImpl<String, String>();
        this.encodedQueryParameters = new MultivaluedMapImpl<String, String>();
        this.extractParameters(queryString);
        this.encodedTemplateParameters = new MultivaluedMapImpl<String, String>();
        this.templateParameters = new MultivaluedMapImpl<String, String>();
        this.encodedPathSegments = encodedPathSegments;
        this.pathSegments = new ArrayList<PathSegment>(encodedPathSegments.size());
        for (PathSegment segment : encodedPathSegments) {
            try {
                this.pathSegments.add(new PathSegmentImpl(URLDecoder.decode(((PathSegmentImpl)segment).getOriginal(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        this.queryString = queryString;
        this.absolutePathWithQueryString = queryString == null ? absolutePath : URI.create(absolutePath.toString() + "?" + queryString);
        if (encodedPath.trim().equals("")) {
            this.baseURI = absolutePath;
        } else {
            String abs = absolutePath.getPath();
            if (!(abs = abs.substring(0, abs.indexOf(encodedPath))).endsWith("/")) {
                abs = abs + "/";
            }
            try {
                this.baseURI = UriBuilder.fromUri((URI)absolutePath).encode(false).replacePath(new String[]{abs}).build();
            }
            catch (Exception e) {
                throw new RuntimeException("URI value was: " + abs + " encodedPath: " + encodedPath, e);
            }
        }
    }

    public UriInfoImpl(List<PathSegment> pathSegments) {
        this.pathSegments = pathSegments;
        this.encodedPathSegments = pathSegments;
    }

    public UriInfoImpl clone() {
        return new UriInfoImpl(this.absolutePath, this.encodedPath, this.queryString, this.encodedPathSegments);
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(boolean decode) {
        if (decode) {
            return this.getPath();
        }
        return this.encodedPath;
    }

    public List<PathSegment> getPathSegments() {
        if (this.pathSegments != null) {
            return this.pathSegments;
        }
        this.pathSegments = PathSegmentImpl.parseSegments(this.getPath());
        return this.pathSegments;
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.getPathSegments();
        }
        return this.encodedPathSegments;
    }

    public URI getRequestUri() {
        return this.absolutePathWithQueryString;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.absolutePathWithQueryString);
    }

    public URI getAbsolutePath() {
        return this.absolutePath;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.absolutePath);
    }

    public URI getBaseUri() {
        return this.baseURI;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.baseURI);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.templateParameters;
    }

    public void addEncodedPathParameter(String name, String value) {
        this.encodedTemplateParameters.add((Object)name, (Object)value);
        try {
            this.templateParameters.add((Object)name, (Object)URLDecoder.decode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            return this.getPathParameters();
        }
        return this.encodedTemplateParameters;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.queryParameters;
        }
        return this.encodedQueryParameters;
    }

    protected void extractParameters(String queryString) {
        String[] params;
        if (queryString == null || queryString.equals("")) {
            return;
        }
        for (String param : params = queryString.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=");
                try {
                    String name = URLDecoder.decode(nv[0], "UTF-8");
                    this.encodedQueryParameters.add((Object)name, (Object)nv[1]);
                    this.queryParameters.add((Object)name, (Object)URLDecoder.decode(nv[1], "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String name = URLDecoder.decode(param, "UTF-8");
                this.encodedQueryParameters.add((Object)name, (Object)"");
                this.queryParameters.add((Object)name, (Object)"");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public UriBuilder getPlatonicRequestUriBuilder() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public String getPathExtension() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public List<String> getAncestorResourceURIs(boolean decode) {
        if (decode) {
            if (this.ancestorUris == null) {
                this.ancestorUris = new ArrayList<String>();
            }
            return this.ancestorUris;
        }
        if (this.encodedAncestorUris == null) {
            this.encodedAncestorUris = new ArrayList<String>();
        }
        return this.ancestorUris;
    }

    public List<String> getAncestorResourceURIs() {
        return this.getAncestorResourceURIs(true);
    }

    public List<Object> getAncestorResources() {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<Object>();
        }
        return this.ancestors;
    }

    public void pushCurrentResource(Object resource) {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<Object>();
        }
        this.ancestors.add(0, resource);
    }

    public void popCurrentResource() {
        if (this.ancestors != null && this.ancestors.size() > 0) {
            this.ancestors.remove(0);
        }
    }

    public void pushAncestorURI(String encoded, String decoded) {
        if (this.encodedAncestorUris == null) {
            this.encodedAncestorUris = new ArrayList<String>();
        }
        this.encodedAncestorUris.add(0, encoded);
        if (this.ancestorUris == null) {
            this.ancestorUris = new ArrayList<String>();
        }
        this.ancestorUris.add(0, decoded);
    }

    public void popAncestorURI() {
        if (this.encodedAncestorUris != null && this.encodedAncestorUris.size() > 0) {
            this.encodedAncestorUris.remove(0);
        }
        if (this.ancestorUris != null && this.ancestorUris.size() > 0) {
            this.ancestorUris.remove(0);
        }
    }
}

