/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.mock;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.resteasy.mock.Assert;
import org.resteasy.mock.MockHttpServletResponse;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final String url;

    public MockRequestDispatcher(String url) {
        Assert.notNull(url, "URL must not be null");
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(response, "Response must not be null");
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        if (!(response instanceof MockHttpServletResponse)) {
            throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
        }
        ((MockHttpServletResponse)response).setForwardedUrl(this.url);
    }

    public void include(ServletRequest request, ServletResponse response) {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(response, "Response must not be null");
        if (!(response instanceof MockHttpServletResponse)) {
            throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
        }
        ((MockHttpServletResponse)response).setIncludedUrl(this.url);
    }
}

