/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.mock;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.resteasy.mock.Assert;

class HeaderValueHolder {
    private final List values = new LinkedList();

    HeaderValueHolder() {
    }

    public void setValue(Object value) {
        this.values.clear();
        this.values.add(value);
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void addValues(Collection values) {
        this.values.addAll(values);
    }

    public void addValueArray(Object[] values) {
        Collections.addAll(this.values, values);
    }

    public List getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public Object getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    public static HeaderValueHolder getByName(Map headers, String name) {
        Assert.notNull(name, "Header name must not be null");
        for (String headerName : headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return (HeaderValueHolder)headers.get(headerName);
        }
        return null;
    }
}

