/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.Types;

class ConstructorGenerator {
    ConstructorGenerator() {
    }

    public void process(ParserClassNode classNode) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Checks.ensure((!classNode.getConstructors().isEmpty() ? 1 : 0) != 0, (String)"Could not extend parser class '%s', no constructor visible to derived classes found", (Object[])new Object[]{classNode.getParentType().getClassName()});
        for (MethodNode constructor : classNode.getConstructors()) {
            this.createConstuctor(classNode, constructor);
        }
        this.createNewInstanceMethod(classNode);
    }

    private void createConstuctor(ParserClassNode classNode, MethodNode constructor) {
        MethodNode newConstructor = new MethodNode(1, constructor.name, constructor.desc, constructor.signature, constructor.exceptions.toArray(new String[constructor.exceptions.size()]));
        InsnList instructions = newConstructor.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add(AsmUtils.createArgumentLoaders(constructor.desc));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.getParentType().getInternalName(), "<init>", constructor.desc));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(newConstructor);
    }

    private void createNewInstanceMethod(ParserClassNode classNode) {
        MethodNode method = new MethodNode(1, "newInstance", "()L" + Types.BASE_PARSER.getInternalName() + ';', null, null);
        InsnList instructions = method.instructions;
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, classNode.name));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.name, "<init>", "()V"));
        instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(method);
    }
}

