/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import org.parboiled.Context;
import org.parboiled.ContextAware;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActions<V>
implements ContextAware<V> {
    private Context<V> context;

    public Context<V> getContext() {
        return this.context;
    }

    public void setContext(Context<V> context) {
        this.context = (Context)Preconditions.checkArgNotNull(context, (String)"context");
    }

    public int currentIndex() {
        this.check();
        return this.context.getCurrentIndex();
    }

    public String match() {
        this.check();
        return this.context.getMatch();
    }

    public IndexRange matchRange() {
        this.check();
        return this.context.getMatchRange();
    }

    public String matchOrDefault(String defaultString) {
        this.check();
        String match = this.context.getMatch();
        return match.length() == 0 ? defaultString : match;
    }

    public char matchedChar() {
        this.check();
        return this.context.getFirstMatchChar();
    }

    public int matchStart() {
        this.check();
        return this.context.getMatchStartIndex();
    }

    public int matchEnd() {
        this.check();
        return this.context.getMatchEndIndex();
    }

    public int matchLength() {
        this.check();
        return this.context.getMatchLength();
    }

    public Position position() {
        this.check();
        return this.context.getPosition();
    }

    public boolean push(V value) {
        this.check();
        this.context.getValueStack().push(value);
        return true;
    }

    public boolean push(int down, V value) {
        this.check();
        this.context.getValueStack().push(down, value);
        return true;
    }

    public boolean pushAll(V firstValue, V ... moreValues) {
        this.check();
        this.context.getValueStack().pushAll(firstValue, (Object[])moreValues);
        return true;
    }

    public V pop() {
        this.check();
        return (V)this.context.getValueStack().pop();
    }

    public V pop(int down) {
        this.check();
        return (V)this.context.getValueStack().pop(down);
    }

    public boolean drop() {
        this.check();
        this.context.getValueStack().pop();
        return true;
    }

    public boolean drop(int down) {
        this.check();
        this.context.getValueStack().pop(down);
        return true;
    }

    public V peek() {
        this.check();
        return (V)this.context.getValueStack().peek();
    }

    public V peek(int down) {
        this.check();
        return (V)this.context.getValueStack().peek(down);
    }

    public boolean poke(V value) {
        this.check();
        this.context.getValueStack().poke(value);
        return true;
    }

    public boolean poke(int down, V value) {
        this.check();
        this.context.getValueStack().poke(down, value);
        return true;
    }

    public boolean dup() {
        this.check();
        this.context.getValueStack().dup();
        return true;
    }

    public boolean swap() {
        this.check();
        this.context.getValueStack().swap();
        return true;
    }

    public boolean swap3() {
        this.check();
        this.context.getValueStack().swap3();
        return true;
    }

    public boolean swap4() {
        this.check();
        this.context.getValueStack().swap4();
        return true;
    }

    public boolean swap5() {
        this.check();
        this.context.getValueStack().swap5();
        return true;
    }

    public boolean swap6() {
        this.check();
        this.context.getValueStack().swap6();
        return true;
    }

    public Character currentChar() {
        this.check();
        return Character.valueOf(this.context.getCurrentChar());
    }

    public boolean inPredicate() {
        this.check();
        return this.context.inPredicate();
    }

    public boolean nodeSuppressed() {
        this.check();
        return this.context.isNodeSuppressed();
    }

    public boolean hasError() {
        this.check();
        return this.context.hasError();
    }

    private void check() {
        Checks.ensure((this.context != null && this.context.getMatcher() != null ? 1 : 0) != 0, (String)"Illegal rule definition: Unwrapped action expression!");
    }
}

