/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport;

import java.io.IOException;
import java.util.Collection;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.lib.Config;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.transport.DaemonClient;
import org.openrewrite.jgit.transport.PacketLineOut;
import org.openrewrite.jgit.transport.ServiceMayNotContinueException;
import org.openrewrite.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.openrewrite.jgit.transport.resolver.ServiceNotEnabledException;

public abstract class DaemonService {
    private final String command;
    private final Config.SectionParser<ServiceConfig> configKey;
    private boolean enabled;
    private boolean overridable;

    DaemonService(String cmdName, String cfgName) {
        this.command = cmdName.startsWith("git-") ? cmdName : "git-" + cmdName;
        this.configKey = cfg -> new ServiceConfig(this, cfg, cfgName);
        this.overridable = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean on) {
        this.enabled = on;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean on) {
        this.overridable = on;
    }

    public String getCommandName() {
        return this.command;
    }

    public boolean handles(String commandLine) {
        return this.command.length() + 1 < commandLine.length() && commandLine.charAt(this.command.length()) == ' ' && commandLine.startsWith(this.command);
    }

    void execute(DaemonClient client, String commandLine, @Nullable Collection<String> extraParameters) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
        String name = commandLine.substring(this.command.length() + 1);
        try (Repository db = client.getDaemon().openRepository(client, name);){
            if (this.isEnabledFor(db)) {
                this.execute(client, db, extraParameters);
            }
        }
        catch (ServiceMayNotContinueException e) {
            PacketLineOut pktOut = new PacketLineOut(client.getOutputStream());
            pktOut.writeString("ERR " + e.getMessage() + "\n");
        }
    }

    private boolean isEnabledFor(Repository db) {
        if (this.isOverridable()) {
            return db.getConfig().get(this.configKey).enabled;
        }
        return this.isEnabled();
    }

    abstract void execute(DaemonClient var1, Repository var2, @Nullable Collection<String> var3) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException;

    private static class ServiceConfig {
        final boolean enabled;

        ServiceConfig(DaemonService service, Config cfg, String name) {
            this.enabled = cfg.getBoolean("daemon", name, service.isEnabled());
        }
    }
}

