/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.differ;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.CollectionItemAccessor;
import de.danielbechler.diff.access.Instances;
import de.danielbechler.diff.comparison.ComparisonStrategy;
import de.danielbechler.diff.comparison.ComparisonStrategyResolver;
import de.danielbechler.diff.differ.Differ;
import de.danielbechler.diff.differ.DifferDispatcher;
import de.danielbechler.diff.identity.IdentityStrategy;
import de.danielbechler.diff.identity.IdentityStrategyResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public final class CollectionDiffer
implements Differ {
    private final DifferDispatcher differDispatcher;
    private final ComparisonStrategyResolver comparisonStrategyResolver;
    private final IdentityStrategyResolver identityStrategyResolver;

    public CollectionDiffer(DifferDispatcher differDispatcher, ComparisonStrategyResolver comparisonStrategyResolver, IdentityStrategyResolver identityStrategyResolver) {
        Assert.notNull(differDispatcher, "differDispatcher");
        this.differDispatcher = differDispatcher;
        Assert.notNull(comparisonStrategyResolver, "comparisonStrategyResolver");
        this.comparisonStrategyResolver = comparisonStrategyResolver;
        Assert.notNull(identityStrategyResolver, "identityStrategyResolver");
        this.identityStrategyResolver = identityStrategyResolver;
    }

    @Override
    public boolean accepts(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    @Override
    public final DiffNode compare(DiffNode parentNode, Instances collectionInstances) {
        DiffNode collectionNode = CollectionDiffer.newNode(parentNode, collectionInstances);
        IdentityStrategy identityStrategy = this.identityStrategyResolver.resolveIdentityStrategy(collectionNode);
        if (identityStrategy != null) {
            collectionNode.setChildIdentityStrategy(identityStrategy);
        }
        if (collectionInstances.hasBeenAdded()) {
            Collection addedItems = collectionInstances.getWorking(Collection.class);
            this.compareItems(collectionNode, collectionInstances, addedItems, identityStrategy);
            collectionNode.setState(DiffNode.State.ADDED);
        } else if (collectionInstances.hasBeenRemoved()) {
            Collection removedItems = collectionInstances.getBase(Collection.class);
            this.compareItems(collectionNode, collectionInstances, removedItems, identityStrategy);
            collectionNode.setState(DiffNode.State.REMOVED);
        } else if (collectionInstances.areSame()) {
            collectionNode.setState(DiffNode.State.UNTOUCHED);
        } else {
            ComparisonStrategy comparisonStrategy = this.comparisonStrategyResolver.resolveComparisonStrategy(collectionNode);
            if (comparisonStrategy == null) {
                this.compareInternally(collectionNode, collectionInstances, identityStrategy);
            } else {
                CollectionDiffer.compareUsingComparisonStrategy(collectionNode, collectionInstances, comparisonStrategy);
            }
        }
        return collectionNode;
    }

    private static DiffNode newNode(DiffNode parentNode, Instances collectionInstances) {
        Accessor accessor = collectionInstances.getSourceAccessor();
        Class<?> type = collectionInstances.getType();
        return new DiffNode(parentNode, accessor, type);
    }

    private void compareItems(DiffNode collectionNode, Instances collectionInstances, Iterable<?> items, IdentityStrategy identityStrategy) {
        for (Object item : items) {
            CollectionItemAccessor itemAccessor = new CollectionItemAccessor(item, identityStrategy);
            this.differDispatcher.dispatch(collectionNode, collectionInstances, itemAccessor);
        }
    }

    private void compareInternally(DiffNode collectionNode, Instances collectionInstances, IdentityStrategy identityStrategy) {
        Collection working = collectionInstances.getWorking(Collection.class);
        Collection base = collectionInstances.getBase(Collection.class);
        LinkedList added = new LinkedList(working);
        LinkedList removed = new LinkedList(base);
        LinkedList known = new LinkedList(base);
        this.remove(added, base, identityStrategy);
        this.remove(removed, working, identityStrategy);
        this.remove(known, added, identityStrategy);
        this.remove(known, removed, identityStrategy);
        this.compareItems(collectionNode, collectionInstances, added, identityStrategy);
        this.compareItems(collectionNode, collectionInstances, removed, identityStrategy);
        this.compareItems(collectionNode, collectionInstances, known, identityStrategy);
    }

    private static void compareUsingComparisonStrategy(DiffNode collectionNode, Instances collectionInstances, ComparisonStrategy comparisonStrategy) {
        comparisonStrategy.compare(collectionNode, collectionInstances.getType(), collectionInstances.getWorking(Collection.class), collectionInstances.getBase(Collection.class));
    }

    private void remove(Iterable<?> from, Iterable<?> these, IdentityStrategy identityStrategy) {
        Iterator<?> iterator = from.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (!this.contains(these, item, identityStrategy)) continue;
            iterator.remove();
        }
    }

    private boolean contains(Iterable<?> haystack, Object needle, IdentityStrategy identityStrategy) {
        for (Object item : haystack) {
            if (!identityStrategy.equals(needle, item)) continue;
            return true;
        }
        return false;
    }
}

