/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class ChangeDependencyClassifier
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="guava")
    private final String artifactId;
    @Option(displayName="New classifier", description="Classifier to apply to specified Maven dependency. May be omitted, which indicates that no classifier should be added and any existing scope be removed from the dependency.", example="jar", required=false)
    private final @Nullable String newClassifier;
    @Option(displayName="Change Maven managed dependency", description="This flag can be set to explicitly change the classifier in Maven management dependency section. Default `false`.", example="true", required=false)
    private final @Nullable Boolean changeManagedDependency;

    public String getDisplayName() {
        return "Change Maven dependency classifier";
    }

    public String getInstanceNameSuffix() {
        return String.format("for `%s:%s` to `%s`", this.groupId, this.artifactId, this.newClassifier);
    }

    public String getDescription() {
        return "Add or alter the classifier of the specified dependency.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag(ChangeDependencyClassifier.this.groupId, ChangeDependencyClassifier.this.artifactId) || Boolean.TRUE.equals(ChangeDependencyClassifier.this.changeManagedDependency) && this.isManagedDependencyTag(ChangeDependencyClassifier.this.groupId, ChangeDependencyClassifier.this.artifactId)) {
                    Optional classifier = tag.getChild("classifier");
                    if (classifier.isPresent()) {
                        if (ChangeDependencyClassifier.this.newClassifier == null) {
                            this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)classifier.get(), false, true));
                        } else if (!ChangeDependencyClassifier.this.newClassifier.equals(((Xml.Tag)classifier.get()).getValue().orElse(null))) {
                            this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)classifier.get(), ChangeDependencyClassifier.this.newClassifier));
                        }
                    } else if (ChangeDependencyClassifier.this.newClassifier != null) {
                        this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, Xml.Tag.build((String)("<classifier>" + ChangeDependencyClassifier.this.newClassifier + "</classifier>"))));
                    }
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }

    @Generated
    public ChangeDependencyClassifier(String groupId, String artifactId, @Nullable String newClassifier, @Nullable Boolean changeManagedDependency) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newClassifier = newClassifier;
        this.changeManagedDependency = changeManagedDependency;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getNewClassifier() {
        return this.newClassifier;
    }

    @Generated
    public @Nullable Boolean getChangeManagedDependency() {
        return this.changeManagedDependency;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeDependencyClassifier(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newClassifier=" + this.getNewClassifier() + ", changeManagedDependency=" + this.getChangeManagedDependency() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyClassifier)) {
            return false;
        }
        ChangeDependencyClassifier other = (ChangeDependencyClassifier)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$changeManagedDependency = this.getChangeManagedDependency();
        Boolean other$changeManagedDependency = other.getChangeManagedDependency();
        if (this$changeManagedDependency == null ? other$changeManagedDependency != null : !((Object)this$changeManagedDependency).equals(other$changeManagedDependency)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newClassifier = this.getNewClassifier();
        String other$newClassifier = other.getNewClassifier();
        return !(this$newClassifier == null ? other$newClassifier != null : !this$newClassifier.equals(other$newClassifier));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeDependencyClassifier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $changeManagedDependency = this.getChangeManagedDependency();
        result = result * 59 + ($changeManagedDependency == null ? 43 : ((Object)$changeManagedDependency).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newClassifier = this.getNewClassifier();
        result = result * 59 + ($newClassifier == null ? 43 : $newClassifier.hashCode());
        return result;
    }
}

