/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.trait;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.trait.internal.MaybeParenthesesPair;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;
import org.openrewrite.trait.VisitFunction2;

@Incubating(since="8.30.0")
public final class VariableAccess
implements Trait<J.Identifier> {
    private final Cursor cursor;

    public boolean isWriteAccess() {
        MaybeParenthesesPair pair = MaybeParenthesesPair.from(this.cursor);
        if (pair.getParent() instanceof J.Assignment) {
            J.Assignment assignment = (J.Assignment)pair.getParent();
            return assignment.getVariable() == pair.getTree();
        }
        if (pair.getParent() instanceof J.Unary) {
            J.Unary unary = (J.Unary)pair.getParent();
            return unary.getExpression() == pair.getTree() && unary.getOperator().isModifying();
        }
        return false;
    }

    public boolean isReadAccess() {
        if (this.isWriteAccess()) {
            return false;
        }
        MaybeParenthesesPair pair = MaybeParenthesesPair.from(this.cursor);
        if (pair.getParent() instanceof J.Assignment) {
            J.Assignment assignment = (J.Assignment)pair.getParent();
            return assignment.getVariable() != pair.getTree();
        }
        if (pair.getParent() instanceof J.Unary) {
            J.Unary unary = (J.Unary)pair.getParent();
            return unary.getExpression() == pair.getTree() && !unary.getOperator().isModifying();
        }
        return true;
    }

    @Generated
    public VariableAccess(Cursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableAccess)) {
            return false;
        }
        VariableAccess other = (VariableAccess)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "VariableAccess(cursor=" + this.getCursor() + ")";
    }

    public static class Matcher
    extends SimpleTraitMatcher<VariableAccess> {
        private Predicate<JavaType> typeTest = t -> true;

        public Matcher isOfType(JavaType type) {
            this.typeTest = t -> TypeUtils.isOfType(t, type);
            return this;
        }

        public Matcher isOfClassType(String fullyQualifiedName) {
            this.typeTest = t -> TypeUtils.isOfClassType(t, fullyQualifiedName);
            return this;
        }

        public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<VariableAccess, P> visitor) {
            return new JavaVisitor<P>(){

                @Override
                public J visitIdentifier(J.Identifier ident, P p) {
                    VariableAccess varAccess = this.test(this.getCursor());
                    return varAccess != null ? (J)visitor.visit((Trait)varAccess, p) : super.visitIdentifier(ident, p);
                }
            };
        }

        public Stream<VariableAccess> higher(Cursor cursor) {
            return Stream.empty();
        }

        protected @Nullable VariableAccess test(Cursor cursor) {
            if (!(cursor.getValue() instanceof J.Identifier)) {
                return null;
            }
            J.Identifier ident = (J.Identifier)cursor.getValue();
            String name = ident.getSimpleName();
            if ("this".equals(name) || "super".equals(name) || this.checkNamePart(cursor, J.VariableDeclarations.NamedVariable.class, J.VariableDeclarations.NamedVariable::getName)) {
                return null;
            }
            if (ident.getFieldType() != null) {
                return this.checkFilters(cursor);
            }
            if (this.checkNamePart(cursor, J.ClassDeclaration.class, J.ClassDeclaration::getName) || this.checkNamePart(cursor, J.MethodDeclaration.class, J.MethodDeclaration::getName) || this.checkNamePart(cursor, J.MethodInvocation.class, J.MethodInvocation::getName) || this.checkNamePart(cursor, J.NewClass.class, J.NewClass::getClazz) || this.checkNamePart(cursor, J.FieldAccess.class, J.FieldAccess::getName) || this.checkNamePart(cursor, J.MethodInvocation.class, J.MethodInvocation::getName) || this.checkNamePart(cursor, J.ParameterizedType.class, J.ParameterizedType::getClazz) || cursor.firstEnclosing(Javadoc.class) != null) {
                return null;
            }
            Cursor parent = cursor.getParentTreeCursor();
            if (this.checkParent(parent, J.TypeCast.class, j -> j.getClazz().getTree() == ident)) {
                return null;
            }
            if (this.checkNamePart(cursor, J.Assignment.class, J.Assignment::getVariable) && this.checkParent(parent, J.Annotation.class, j -> j.getArguments() != null && j.getArguments().contains(ident))) {
                return null;
            }
            if (this.checkNamePart(cursor, J.ArrayAccess.class, J.ArrayAccess::getIndexed) || this.checkNamePart(cursor, J.ArrayDimension.class, J.ArrayDimension::getIndex) || this.checkNamePart(cursor, J.ControlParentheses.class, J.ControlParentheses::getTree) || this.checkNamePart(cursor, J.ForEachLoop.Control.class, J.ForEachLoop.Control::getIterable) || this.checkNamePart(cursor, J.ForLoop.Control.class, J.ForLoop.Control::getCondition) || this.checkNamePart(cursor, J.Parentheses.class, J.Parentheses::getTree) || this.checkNamePart(cursor, J.TypeCast.class, J.TypeCast::getExpression) || this.checkNamePart(cursor, J.Unary.class, J.Unary::getExpression) || this.checkNamePart(cursor, J.VariableDeclarations.NamedVariable.class, J.VariableDeclarations.NamedVariable::getInitializer) || this.checkParent(cursor, J.Assignment.class, a -> a.getVariable() == ident || a.getAssignment() == ident) || this.checkParent(cursor, J.Binary.class, b -> b.getLeft() == ident || b.getRight() == ident) || this.checkParent(cursor, J.MethodInvocation.class, m -> m.getSelect() == ident || m.getArguments().contains(ident)) || this.checkParent(cursor, J.NewClass.class, n -> n.getEnclosing() == ident || n.getArguments().contains(ident)) || this.checkParent(cursor, J.NewArray.class, n -> n.getInitializer() != null && n.getInitializer().contains(ident)) || this.checkParent(cursor, J.Ternary.class, t -> t.getCondition() == ident || t.getTruePart() == ident || t.getFalsePart() == ident) || this.checkParent(cursor, J.Annotation.class, parentAnnotation -> parentAnnotation.getArguments() != null && parentAnnotation.getArguments().contains(ident))) {
                return this.checkFilters(cursor);
            }
            return null;
        }

        private @Nullable VariableAccess checkFilters(Cursor cursor) {
            return this.typeTest.test(((J.Identifier)cursor.getValue()).getType()) ? new VariableAccess(cursor) : null;
        }

        private <J2> boolean checkParent(Cursor cursor, Class<J2> parentType, Predicate<J2> test) {
            if (cursor.getValue() instanceof SourceFile) {
                return false;
            }
            Object parent = cursor.getParentTreeCursor().getValue();
            return parentType.isInstance(parent) && test.test(parentType.cast(parent));
        }

        private <J2 extends J> boolean checkNamePart(Cursor cursor, Class<J2> parentType, Function<J2, J> nameExtractor) {
            return this.checkParent(cursor, parentType, j -> nameExtractor.apply(j) == cursor.getValue());
        }
    }
}

