/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.service;

import java.util.regex.Pattern;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.NamingService;

public class JavaNamingService
implements NamingService {
    private static final Pattern STANDARD_METHOD_NAME = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    private static final Pattern SNAKE_CASE = Pattern.compile("^[a-zA-Z0-9]+_\\w+$");

    public String standardizeMethodName(String oldMethodName) {
        if (!oldMethodName.startsWith("_") && !STANDARD_METHOD_NAME.matcher(oldMethodName).matches()) {
            StringBuilder result = new StringBuilder();
            if (SNAKE_CASE.matcher(oldMethodName).matches()) {
                result.append(NameCaseConvention.format((NameCaseConvention)NameCaseConvention.LOWER_CAMEL, (String)oldMethodName));
            } else {
                int nameLength = oldMethodName.length();
                for (int i = 0; i < nameLength; ++i) {
                    char c = oldMethodName.charAt(i);
                    if (i == 0) {
                        if (c == '$' || c == '_') continue;
                        result.append(Character.toLowerCase(c));
                        continue;
                    }
                    if (!Character.isLetterOrDigit(c)) {
                        while (!(Character.isLetterOrDigit(c) && c <= 'z' || ++i >= nameLength)) {
                            c = oldMethodName.charAt(i);
                        }
                        if (i >= nameLength) continue;
                        result.append(Character.toUpperCase(c));
                        continue;
                    }
                    result.append(c);
                }
            }
            return result.toString();
        }
        return oldMethodName;
    }
}

