/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public final class MaskCreditCardNumbers
extends Recipe {
    private static final Pattern CC_PATTERN = Pattern.compile("([0-9]{4} ?[0-9]{4} ?)([0-9]{4} ?[0-9]{4} ?)");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d");

    public String getDisplayName() {
        return "Mask credit card numbers";
    }

    public String getDescription() {
        return "When encountering string literals which appear to be credit card numbers, mask the last eight digits with the letter 'X'.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J.Literal l = super.visitLiteral(literal, (Object)ctx);
                if (l.getValue() instanceof String) {
                    String value = (String)l.getValue();
                    Matcher m = CC_PATTERN.matcher(value);
                    if (m.matches()) {
                        String masked = m.group(1) + MaskCreditCardNumbers.maskDigits(m.group(2));
                        l = l.withValue((Object)masked).withValueSource("\"" + masked + "\"");
                    }
                }
                return l;
            }
        };
    }

    private static String maskDigits(String digits) {
        return DIGIT_PATTERN.matcher(digits).replaceAll("X");
    }

    @Generated
    public MaskCreditCardNumbers() {
    }

    @Generated
    public String toString() {
        return "MaskCreditCardNumbers()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaskCreditCardNumbers)) {
            return false;
        }
        MaskCreditCardNumbers other = (MaskCreditCardNumbers)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MaskCreditCardNumbers;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

