/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class JulToSlf4jLambdaSupplierWithThrowableRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace JUL `log(Level, Throwable, Supplier<String>)` with corresponding SLF4J method calls";
    }

    public String getDescription() {
        return "Replace calls to `Logger.log(Level, Throwable, Supplier<String>)` with the corresponding SLF4J method calls.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new JulToSlf4jSupplierFinestRecipe(), new JulToSlf4jSupplierFinerRecipe(), new JulToSlf4jSupplierFineRecipe(), new JulToSlf4jSupplierConfigRecipe(), new JulToSlf4jSupplierInfoRecipe(), new JulToSlf4jSupplierWarningRecipe(), new JulToSlf4jSupplierSevereRecipe(), new JulToSlf4jSupplierAllRecipe()});
    }

    @NullMarked
    public static class JulToSlf4jSupplierFinestRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.FINEST, e, Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINEST, e, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINEST, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierFinerRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.FINER, e, Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINER, e, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINER, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierFineRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.FINE, e, Supplier<String>)` with SLF4J's `Logger.atDebug().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.FINE, e, Supplier<String>)` with `org.slf4j.Logger.atDebug().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.FINE, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atDebug().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierConfigRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.CONFIG, e, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.CONFIG, e, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.CONFIG, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atInfo().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierInfoRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.INFO, e, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.INFO, e, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.INFO, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atInfo().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierWarningRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.WARNING, e, Supplier<String>)` with SLF4J's `Logger.atWarn().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.WARNING, e, Supplier<String>)` with `org.slf4j.Logger.atWarn().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.WARNING, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atWarn().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierSevereRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.SEVERE, e, Supplier<String>)` with SLF4J's `Logger.atError().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.SEVERE, e, Supplier<String>)` with `org.slf4j.Logger.atError().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.SEVERE, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atError().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class JulToSlf4jSupplierAllRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace JUL `logger.log(Level.ALL, e, Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`";
        }

        public String getDescription() {
            return "Replace calls to `java.util.logging.Logger.log(Level.ALL, e, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{logger:any(java.util.logging.Logger)}.log(java.util.logging.Level.ALL, #{e:any(java.lang.Throwable)}, #{supplier:any(java.util.function.Supplier<java.lang.String>)});").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{logger:any(org.slf4j.Logger)}.atTrace().setCause(#{e:any(java.lang.Throwable)}).log(#{supplier:any(java.util.function.Supplier<java.lang.String>)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.util.logging.Level");
                        this.maybeRemoveImport("java.util.logging.Logger");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesType("java.util.logging.Level", Boolean.valueOf(true)), new UsesType("java.util.logging.Logger", Boolean.valueOf(true)), new UsesMethod("java.util.logging.Logger log(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

