/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.templating.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class SplitStringLambda
implements Mustache.Lambda {
    private static final int DEFAULT_MAX_LENGTH = 65535;
    private static final String SPLIT_INIT = "new StringBuilder(%d)";
    private static final String SPLIT_PART = ".append(\"%s\")";
    private static final String SPLIT_SUFFIX = ".toString()";
    private final int maxLength;

    public SplitStringLambda() {
        this(65535);
    }

    public SplitStringLambda(int maxLength) {
        this.maxLength = maxLength;
    }

    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String input = fragment.execute();
        int inputLength = input.length();
        StringBuilder builder = new StringBuilder();
        if (inputLength > this.maxLength) {
            builder.append(String.format(Locale.ROOT, SPLIT_INIT, inputLength));
            int currentPosition = 0;
            int currentStringLength = 0;
            int currentLastChar = 92;
            while (currentPosition + this.maxLength < input.length()) {
                currentStringLength = this.maxLength;
                currentLastChar = input.charAt(currentPosition + currentStringLength - 1);
                if (currentLastChar == 92) {
                    --currentStringLength;
                }
                builder.append(String.format(Locale.ROOT, SPLIT_PART, input.substring(currentPosition, currentPosition + currentStringLength)));
                currentPosition += currentStringLength;
            }
            if (currentPosition < input.length()) {
                builder.append(String.format(Locale.ROOT, SPLIT_PART, input.substring(currentPosition)));
            }
            builder.append(SPLIT_SUFFIX);
        } else {
            builder.append(String.format(Locale.ROOT, "\"%s\"", input));
        }
        writer.write(builder.toString());
    }
}

