/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.PhpSlimServerCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpSlim4ServerCodegen
extends PhpSlimServerCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpSlim4ServerCodegen.class);
    public static final String PSR7_IMPLEMENTATION = "psr7Implementation";
    protected String psr7Implementation = "slim-psr7";
    protected String mockDirName = "Mock";
    protected String mockPackage = "";
    protected String utilsDirName = "Utils";
    protected String utilsPackage = "";
    protected String interfacesDirName = "Interfaces";
    protected String interfacesPackage = "";

    public PhpSlim4ServerCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.mockPackage = this.invokerPackage + "\\" + this.mockDirName;
        this.utilsPackage = this.invokerPackage + "\\" + this.utilsDirName;
        this.interfacesPackage = this.invokerPackage + "\\" + this.interfacesDirName;
        this.outputFolder = "generated-code" + File.separator + "slim4";
        this.templateDir = "php-slim4-server";
        this.embeddedTemplateDir = "php-slim4-server";
        this.updateOption("variableNamingConvention", "camelCase");
        CliOption psr7Option = new CliOption(PSR7_IMPLEMENTATION, "Slim 4 provides its own PSR-7 implementation so that it works out of the box. However, you are free to replace Slim\u2019s default PSR-7 objects with a third-party implementation. Ref: https://www.slimframework.com/docs/v4/concepts/value-objects.html");
        psr7Option.addEnum("slim-psr7", "Slim PSR-7 Message implementation").addEnum("nyholm-psr7", "Nyholm PSR-7 Message implementation").addEnum("guzzle-psr7", "Guzzle PSR-7 Message implementation").addEnum("zend-diactoros", "Zend Diactoros PSR-7 Message implementation").setDefault("slim-psr7");
        this.cliOptions.add(psr7Option);
    }

    @Override
    public String getName() {
        return "php-slim4";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Slim 4 Framework server library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.mockPackage = this.invokerPackage + "\\" + this.mockDirName;
            this.utilsPackage = this.invokerPackage + "\\" + this.utilsDirName;
            this.interfacesPackage = this.invokerPackage + "\\" + this.interfacesDirName;
        }
        this.additionalProperties.put("mockPackage", this.mockPackage);
        this.additionalProperties.put("mockSrcPath", "./" + this.toSrcPath(this.mockPackage, this.srcBasePath));
        this.additionalProperties.put("mockTestPath", "./" + this.toSrcPath(this.mockPackage, this.testBasePath));
        this.additionalProperties.put("utilsPackage", this.utilsPackage);
        this.additionalProperties.put("utilsSrcPath", "./" + this.toSrcPath(this.utilsPackage, this.srcBasePath));
        this.additionalProperties.put("utilsTestPath", "./" + this.toSrcPath(this.utilsPackage, this.testBasePath));
        this.additionalProperties.put("interfacesPackage", this.interfacesPackage);
        this.additionalProperties.put("interfacesSrcPath", "./" + this.toSrcPath(this.interfacesPackage, this.srcBasePath));
        this.additionalProperties.put("interfacesTestPath", "./" + this.toSrcPath(this.interfacesPackage, this.testBasePath));
        this.additionalProperties.put("docsBasePath", "./" + this.docsBasePath);
        if (this.additionalProperties.containsKey(PSR7_IMPLEMENTATION)) {
            this.setPsr7Implementation((String)this.additionalProperties.get(PSR7_IMPLEMENTATION));
        }
        this.additionalProperties.put("isSlimPsr7", Boolean.FALSE);
        this.additionalProperties.put("isNyholmPsr7", Boolean.FALSE);
        this.additionalProperties.put("isGuzzlePsr7", Boolean.FALSE);
        this.additionalProperties.put("isZendDiactoros", Boolean.FALSE);
        switch (this.getPsr7Implementation()) {
            case "slim-psr7": {
                this.additionalProperties.put("isSlimPsr7", Boolean.TRUE);
                break;
            }
            case "nyholm-psr7": {
                this.additionalProperties.put("isNyholmPsr7", Boolean.TRUE);
                break;
            }
            case "guzzle-psr7": {
                this.additionalProperties.put("isGuzzlePsr7", Boolean.TRUE);
                break;
            }
            case "zend-diactoros": {
                this.additionalProperties.put("isZendDiactoros", Boolean.TRUE);
                break;
            }
            default: {
                LOGGER.warn("\"" + this.getPsr7Implementation() + "\" is invalid \"psr7Implementation\" codegen option. Default \"slim-psr7\" used instead.");
                this.additionalProperties.put("isSlimPsr7", Boolean.TRUE);
            }
        }
        this.supportingFiles.add(new SupportingFile("json_body_parser_middleware.mustache", this.toSrcPath(this.invokerPackage + "\\Middleware", this.srcBasePath), "JsonBodyParserMiddleware.php"));
        this.supportingFiles.add(new SupportingFile("openapi_data_mocker_interface.mustache", this.toSrcPath(this.mockPackage, this.srcBasePath), this.toInterfaceName("OpenApiDataMocker") + ".php"));
        this.supportingFiles.add(new SupportingFile("openapi_data_mocker.mustache", this.toSrcPath(this.mockPackage, this.srcBasePath), "OpenApiDataMocker.php"));
        this.supportingFiles.add(new SupportingFile("openapi_data_mocker_test.mustache", this.toSrcPath(this.mockPackage, this.testBasePath), "OpenApiDataMockerTest.php"));
        this.supportingFiles.add(new SupportingFile("openapi_data_mocker_middleware.mustache", this.toSrcPath(this.mockPackage, this.srcBasePath), "OpenApiDataMockerMiddleware.php"));
        this.supportingFiles.add(new SupportingFile("openapi_data_mocker_middleware_test.mustache", this.toSrcPath(this.mockPackage, this.testBasePath), "OpenApiDataMockerMiddlewareTest.php"));
        this.supportingFiles.add(new SupportingFile("mock_server.mustache", this.docsBasePath, "MockServer.md"));
        this.supportingFiles.add(new SupportingFile("string_utils_trait.mustache", this.toSrcPath(this.utilsPackage, this.srcBasePath), this.toTraitName("StringUtils") + ".php"));
        this.supportingFiles.add(new SupportingFile("string_utils_trait_test.mustache", this.toSrcPath(this.utilsPackage, this.testBasePath), this.toTraitName("StringUtils") + "Test.php"));
        this.supportingFiles.add(new SupportingFile("model_utils_trait.mustache", this.toSrcPath(this.utilsPackage, this.srcBasePath), this.toTraitName("ModelUtils") + ".php"));
        this.supportingFiles.add(new SupportingFile("model_utils_trait_test.mustache", this.toSrcPath(this.utilsPackage, this.testBasePath), this.toTraitName("ModelUtils") + "Test.php"));
        this.supportingFiles.add(new SupportingFile("model_interface.mustache", this.toSrcPath(this.interfacesPackage, this.srcBasePath), this.toInterfaceName("Model") + ".php"));
    }

    public void setPsr7Implementation(String psr7Implementation) {
        switch (psr7Implementation) {
            case "slim-psr7": 
            case "nyholm-psr7": 
            case "guzzle-psr7": 
            case "zend-diactoros": {
                this.psr7Implementation = psr7Implementation;
                break;
            }
            default: {
                this.psr7Implementation = "slim-psr7";
                LOGGER.warn("\"" + psr7Implementation + "\" is invalid \"psr7Implementation\" argument. Default \"slim-psr7\" used instead.");
            }
        }
    }

    public String getPsr7Implementation() {
        return this.psr7Implementation;
    }
}

