/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.GoClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoClientExperimentalCodegen
extends GoClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoClientExperimentalCodegen.class);

    public GoClientExperimentalCodegen() {
        this.outputFolder = "generated-code/go-experimental";
        this.templateDir = "go-experimental";
        this.embeddedTemplateDir = "go-experimental";
        this.usesOptionals = false;
        this.useOneOfInterfaces = true;
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
    }

    @Override
    public String getName() {
        return "go-experimental";
    }

    @Override
    public String toGetter(String name) {
        return "Get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String getHelp() {
        return "Generates a Go client library (experimental and may subject to breaking changes without further notice).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("utils.mustache", "", "utils.go"));
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("signing.mustache", "", "signing.go"));
        }
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.toModel(name, false));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return name + '_';
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        String prefix = "";
        if (this.enumClassPrefix) {
            prefix = datatype.toUpperCase(Locale.ROOT) + "_";
        }
        return prefix + value;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        String enumDefault = null;
        if (var.isEnum && var.defaultValue != null) {
            enumDefault = var.defaultValue;
        }
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum && enumDefault != null) {
            var.defaultValue = enumDefault;
        }
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p = ModelUtils.getReferencedSchema(this.openAPI, p))) {
            if (p.getDefault() != null) {
                return "\"" + this.escapeText((String)p.getDefault()) + "\"";
            }
            return null;
        }
        return super.toDefaultValue(p);
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty prop = super.fromProperty(name, p);
        String cc = StringUtils.camelize(prop.name, true);
        if (this.isReservedWord(cc)) {
            cc = this.escapeReservedWord(cc);
        }
        prop.nameInCamelCase = cc;
        return prop;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        for (Map m : models) {
            Object v = m.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel model = (CodegenModel)v;
            if (model.isEnum) continue;
            for (CodegenProperty param : model.vars) {
                param.vendorExtensions.put("x-go-base-type", param.dataType);
                if (!param.isNullable || param.isMapContainer || param.isListContainer || param.isFreeFormObject || param.isAnyType) continue;
                if (param.isDateTime) {
                    param.dataType = "NullableTime";
                    continue;
                }
                param.dataType = "Nullable" + Character.toUpperCase(param.dataType.charAt(0)) + param.dataType.substring(1);
            }
        }
        return objs;
    }

    @Override
    public void addImportsToOneOfInterface(List<Map<String, String>> imports) {
        for (final String i : Arrays.asList("fmt")) {
            HashMap<String, String> oneImport = new HashMap<String, String>(){
                {
                    this.put("import", i);
                }
            };
            if (imports.contains(oneImport)) continue;
            imports.add((Map<String, String>)oneImport);
        }
    }
}

