/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwiftClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String RESPONSE_AS = "responseAs";
    public static final String UNWRAP_REQUIRED = "unwrapRequired";
    public static final String POD_SOURCE = "podSource";
    public static final String POD_AUTHORS = "podAuthors";
    public static final String POD_SOCIAL_MEDIA_URL = "podSocialMediaURL";
    public static final String POD_DOCSET_URL = "podDocsetURL";
    public static final String POD_LICENSE = "podLicense";
    public static final String POD_HOMEPAGE = "podHomepage";
    public static final String POD_SUMMARY = "podSummary";
    public static final String POD_DESCRIPTION = "podDescription";
    public static final String POD_SCREENSHOTS = "podScreenshots";
    public static final String POD_DOCUMENTATION_URL = "podDocumentationURL";
    public static final String SWIFT_USE_API_NAMESPACE = "swiftUseApiNamespace";
    public static final String DEFAULT_POD_AUTHORS = "OpenAPI Generator";
    protected static final String LIBRARY_PROMISE_KIT = "PromiseKit";
    protected static final String LIBRARY_RX_SWIFT = "RxSwift";
    protected static final String[] RESPONSE_LIBRARIES = new String[]{"PromiseKit", "RxSwift"};
    protected String projectName = "OpenAPIClient";
    protected boolean unwrapRequired;
    protected boolean swiftUseApiNamespace;
    protected String[] responseAs = new String[0];
    protected String sourceFolder = "Classes" + File.separator + "OpenAPIs";
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{[a-zA-Z_]+\\}");

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "swift2-deprecated";
    }

    @Override
    public String getHelp() {
        return "Generates a Swift (2.x) client library. IMPORTANT NOTE: this generator (swfit 2.x)  is no longer actively maintained so please use 'swift4' generator instead.";
    }

    public SwiftClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.DEPRECATED).build();
        this.featureSet = this.getFeatureSet().modify().wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).build();
        this.outputFolder = "generated-code" + File.separator + "swift";
        this.modelTemplateFiles.put("model.mustache", ".swift");
        this.apiTemplateFiles.put("api.mustache", ".swift");
        this.templateDir = "swift";
        this.embeddedTemplateDir = "swift";
        this.apiPackage = File.separator + "APIs";
        this.modelPackage = File.separator + "Models";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Int", "Int32", "Int64", "Float", "Double", "Bool", "Void", "String", "Character", "AnyObject"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("NSData", "NSDate", "NSURL", "NSUUID", "Array", "Dictionary", "Set", "Any", "Empty", "AnyObject"));
        this.reservedWords = new HashSet<String>(Arrays.asList("ErrorResponse", "Int", "Int32", "Int64", "Int64", "Float", "Double", "Bool", "Void", "String", "Character", "AnyObject", "class", "Class", "break", "as", "associativity", "deinit", "case", "dynamicType", "convenience", "enum", "continue", "false", "dynamic", "extension", "default", "is", "didSet", "func", "do", "nil", "final", "import", "else", "self", "get", "init", "fallthrough", "Self", "infix", "internal", "for", "super", "inout", "let", "if", "true", "lazy", "operator", "in", "COLUMN", "left", "private", "return", "FILE", "mutating", "protocol", "switch", "FUNCTION", "none", "public", "where", "LINE", "nonmutating", "static", "while", "optional", "struct", "override", "subscript", "postfix", "typealias", "precedence", "var", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak", "Data", "fileprivate", "open", "rethrows", "defer", "guard", "repeat", "Any", "catch", "throw", "throws", "try", "indirect", "willSet"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("date", "ISOFullDate");
        this.typeMapping.put("Date", "ISOFullDate");
        this.typeMapping.put("DateTime", "NSDate");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int32");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Int32");
        this.typeMapping.put("Integer", "Int32");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "AnyObject");
        this.typeMapping.put("file", "NSURL");
        this.typeMapping.put("binary", "NSURL");
        this.typeMapping.put("ByteArray", "NSData");
        this.typeMapping.put("UUID", "NSUUID");
        this.typeMapping.put("URI", "String");
        this.importMapping = new HashMap();
        this.cliOptions.add(new CliOption(PROJECT_NAME, "Project name in Xcode"));
        this.cliOptions.add(new CliOption(RESPONSE_AS, "Optionally use libraries to manage response.  Currently " + org.apache.commons.lang3.StringUtils.join((Object[])RESPONSE_LIBRARIES, (String)", ") + " are available."));
        this.cliOptions.add(new CliOption(UNWRAP_REQUIRED, "Treat 'required' properties in response as non-optional (which would crash the app if api returns null as opposed to required option specified in json schema"));
        this.cliOptions.add(new CliOption(POD_SOURCE, "Source information used for Podspec"));
        this.cliOptions.add(new CliOption("podVersion", "Version used for Podspec"));
        this.cliOptions.add(new CliOption(POD_AUTHORS, "Authors used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SOCIAL_MEDIA_URL, "Social Media URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCSET_URL, "Docset URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_LICENSE, "License used for Podspec"));
        this.cliOptions.add(new CliOption(POD_HOMEPAGE, "Homepage used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SUMMARY, "Summary used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DESCRIPTION, "Description used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SCREENSHOTS, "Screenshots used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCUMENTATION_URL, "Documentation URL used for Podspec"));
        this.cliOptions.add(new CliOption(SWIFT_USE_API_NAMESPACE, "Flag to make all the API classes inner-class of {{projectName}}API"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        } else {
            this.additionalProperties.put(PROJECT_NAME, this.projectName);
        }
        this.sourceFolder = this.projectName + File.separator + this.sourceFolder;
        if (this.additionalProperties.containsKey(UNWRAP_REQUIRED)) {
            this.setUnwrapRequired(this.convertPropertyToBooleanAndWriteBack(UNWRAP_REQUIRED));
        }
        if (this.additionalProperties.containsKey(RESPONSE_AS)) {
            Object responseAsObject = this.additionalProperties.get(RESPONSE_AS);
            if (responseAsObject instanceof String) {
                this.setResponseAs(((String)responseAsObject).split(","));
            } else {
                this.setResponseAs((String[])responseAsObject);
            }
        }
        this.additionalProperties.put(RESPONSE_AS, this.responseAs);
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_PROMISE_KIT)) {
            this.additionalProperties.put("usePromiseKit", true);
        }
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_RX_SWIFT)) {
            this.additionalProperties.put("useRxSwift", true);
        }
        if (this.additionalProperties.containsKey(SWIFT_USE_API_NAMESPACE)) {
            this.setSwiftUseApiNamespace(this.convertPropertyToBooleanAndWriteBack(SWIFT_USE_API_NAMESPACE));
        }
        if (!this.additionalProperties.containsKey(POD_AUTHORS)) {
            this.additionalProperties.put(POD_AUTHORS, DEFAULT_POD_AUTHORS);
        }
        this.supportingFiles.add(new SupportingFile("Podspec.mustache", "", this.projectName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("Cartfile.mustache", "", "Cartfile"));
        this.supportingFiles.add(new SupportingFile("APIHelper.mustache", this.sourceFolder, "APIHelper.swift"));
        this.supportingFiles.add(new SupportingFile("AlamofireImplementations.mustache", this.sourceFolder, "AlamofireImplementations.swift"));
        this.supportingFiles.add(new SupportingFile("Extensions.mustache", this.sourceFolder, "Extensions.swift"));
        this.supportingFiles.add(new SupportingFile("Models.mustache", this.sourceFolder, "Models.swift"));
        this.supportingFiles.add(new SupportingFile("APIs.mustache", this.sourceFolder, "APIs.swift"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "[String:" + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type) || this.defaultIncludes.contains(type)) {
                return type;
            }
        } else {
            type = schemaType;
        }
        return this.toModelName(type);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("NSURL");
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType != null && dataType.equals("NSData");
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name))) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toDefaultValue(Schema p) {
        return null;
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getAdditionalProperties(p));
            return "[String:" + inner + "]";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return "[" + inner + "]";
        }
        return null;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty codegenProperty = super.fromProperty(name, p);
        if (Boolean.TRUE.equals(codegenProperty.isContainer)) {
            return codegenProperty;
        }
        if (codegenProperty.isEnum) {
            ArrayList swiftEnums = new ArrayList();
            List values = (List)codegenProperty.allowableValues.get("values");
            for (Object value : values) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("enum", this.toSwiftyEnumName(String.valueOf(value)));
                map.put("raw", String.valueOf(value));
                swiftEnums.add(map);
            }
            codegenProperty.allowableValues.put("values", swiftEnums);
            codegenProperty.datatypeWithEnum = this.toEnumName(codegenProperty);
            if (this.isReservedWord(codegenProperty.datatypeWithEnum) || this.toVarName(name).equals(codegenProperty.datatypeWithEnum)) {
                codegenProperty.datatypeWithEnum = codegenProperty.datatypeWithEnum + "Enum";
            }
        }
        return codegenProperty;
    }

    public String toSwiftyEnumName(String value) {
        if (value.length() == 0) {
            return "Empty";
        }
        if (value.matches("^-?\\d*\\.{0,1}\\d+.*")) {
            value = "Number" + value;
            value = value.replaceAll("-", "Minus");
            value = value.replaceAll("\\+", "Plus");
            value = value.replaceAll("\\.", "Dot");
        }
        if (value.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            return value;
        }
        char[] separators = new char[]{'-', '_', ' ', ':', '/'};
        return WordUtils.capitalizeFully((String)org.apache.commons.lang3.StringUtils.lowerCase((String)value), (char[])separators).replaceAll("[-_  :/]", "");
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultAPI";
        }
        return StringUtils.camelize(name) + "API";
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(operationId = StringUtils.camelize(this.sanitizeName(operationId), true)))) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = StringUtils.camelize(this.sanitizeName("call_" + operationId), true);
        }
        return operationId;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        path = SwiftClientCodegen.normalizePath(path);
        return super.fromOperation(path, httpMethod, operation, servers);
    }

    private static String normalizePath(String path) {
        StringBuilder builder = new StringBuilder();
        int cursor = 0;
        Matcher matcher = PATH_PARAM_PATTERN.matcher(path);
        boolean found = matcher.find();
        while (found) {
            String stringBeforeMatch = path.substring(cursor, matcher.start());
            builder.append(stringBeforeMatch);
            String group = matcher.group().substring(1, matcher.group().length() - 1);
            group = StringUtils.camelize(group, true);
            builder.append("{").append(group).append("}");
            cursor = matcher.end();
            found = matcher.find();
        }
        String stringAfterMatch = path.substring(cursor);
        builder.append(stringAfterMatch);
        return builder.toString();
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setUnwrapRequired(boolean unwrapRequired) {
        this.unwrapRequired = unwrapRequired;
    }

    public void setResponseAs(String[] responseAs) {
        this.responseAs = responseAs;
    }

    public void setSwiftUseApiNamespace(boolean swiftUseApiNamespace) {
        this.swiftUseApiNamespace = swiftUseApiNamespace;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name);
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

