/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.ui.action;

import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.publication.entities.WikittyPubDataHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.publication.ui.action.PublicationBaseAction;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.operators.Element;

public class PublicationActionEdit
extends PublicationBaseAction {
    private static final long serialVersionUID = -590087371230933701L;
    private static Log log = LogFactory.getLog(PublicationActionEdit.class);
    protected Wikitty wikitty;
    protected HashMap<String, Object> wikittyFieldMap;
    protected WikittyProxy proxy;
    protected boolean isDelete;
    protected boolean isStore;
    protected String wikittyId = "";
    protected String version = "";
    protected File uploadedFile;
    protected String uploadFileName;
    protected String uploadContentType;

    public static PublicationActionEdit getAction() {
        return (PublicationActionEdit)ActionContext.getContext().get("action");
    }

    public String execute() throws Exception {
        this.proxy = this.getWikittyPublicationProxy();
        Map param = ActionContext.getContext().getParameters();
        this.formatArgs(param);
        this.isDelete = param.containsKey("delete");
        this.isStore = param.containsKey("store");
        this.wikittyId = this.getArgument("id", "");
        this.version = this.getArgument("version", "");
        this.doAction();
        this.putIdArgs(this.wikitty.getId());
        return "success";
    }

    public void doAction() {
        if (this.isDelete) {
            log.info((Object)"delete requested");
            log.debug((Object)this.wikitty);
            String id = this.wikittyId;
            this.proxy.delete(id);
            this.wikitty = new WikittyImpl();
            this.wikittyId = this.wikitty.getId();
        } else {
            ArrayList argsString = new ArrayList();
            String args = ActionContext.getContext().getParameters().get(ARGS_KEY).toString();
            String[] argsTab = StringUtil.split((String)args, (String)SEPARATOR);
            Collections.addAll(argsString, argsTab);
            Criteria criteria = this.searchCriteria(argsString);
            this.wikitty = criteria == null ? new WikittyImpl() : this.proxy.findByCriteria(criteria);
            if (this.wikitty == null && this.wikittyId != null) {
                String id = this.wikittyId;
                this.wikitty = new WikittyImpl(id);
            }
            if (this.wikitty == null) {
                this.wikitty = new WikittyImpl();
            } else {
                WikittyExtension ext;
                String extName;
                Object ext2;
                String extensions = this.getArgument("extensions", null);
                if (extensions != null) {
                    String[] exts;
                    for (String extName2 : exts = StringUtil.split((String)extensions.replace("[", "").replace("]", ""), (String)",")) {
                        ext2 = this.proxy.restoreExtensionLastVersion(extName2.trim());
                        if (ext2 == null) continue;
                        this.wikitty.addExtension((WikittyExtension)ext2);
                    }
                }
                if ((extName = this.getArgument("newExtension", null)) != null && !"".equals(extName) && (ext = this.proxy.restoreExtensionLastVersion(extName)) != null) {
                    this.wikitty.addExtension(ext);
                }
                for (Map.Entry field : this.wikittyFieldMap.entrySet()) {
                    FieldType extFieldType;
                    String fieldName;
                    String key = (String)field.getKey();
                    ArrayList<String> value = null;
                    if (!key.contains(".") || !this.wikitty.hasField((String)(ext2 = WikittyExtension.extractExtensionName((String)key)), fieldName = WikittyExtension.extractFieldName((String)key))) continue;
                    if (!"true".equals(this.getArgument("isNull-" + key, "false"))) {
                        value = (ArrayList<String>)field.getValue();
                    }
                    if ((extFieldType = this.wikitty.getExtension((String)ext2).getFieldType(fieldName)).isCollection() && extFieldType.getType() == FieldType.TYPE.STRING && value != null) {
                        String[] valuesString;
                        String valueString = ((Object)value).toString();
                        valueString = new String(valueString.substring(1, valueString.length() - 1));
                        ArrayList<String> list = new ArrayList<String>();
                        for (String element : valuesString = StringUtil.split((String)valueString, (String)",")) {
                            list.add(element.trim());
                        }
                        value = list;
                    }
                    if (((String)ext2).equals("WikittyPubData") && fieldName.equals("name") && value == null) {
                        String extension = "." + FileUtil.extension((String)this.uploadFileName, (String[])new String[0]);
                        String fileName = FileUtil.basename((String)this.uploadFileName, (String[])new String[]{extension});
                        value = fileName;
                    }
                    this.wikitty.setField((String)ext2, fieldName, (Object)value);
                    if (!((String)ext2).equals("WikittyPubData") || !fieldName.equals("content") || null != WikittyPubDataHelper.getMimeType((Wikitty)this.wikitty)) continue;
                    WikittyPubDataHelper.setMimeType((Wikitty)this.wikitty, (String)this.uploadContentType);
                }
                if (this.isStore) {
                    log.info((Object)"store requested");
                    log.debug((Object)this.wikitty);
                    this.wikitty = this.proxy.store(this.wikitty);
                }
            }
        }
    }

    public void setFile(File upload) {
        this.uploadedFile = upload;
    }

    public String getFileContentType() {
        return this.uploadContentType;
    }

    public void setFileContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getFileFileName() {
        return this.uploadFileName;
    }

    public void setFileFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public Wikitty getWikitty() {
        return this.wikitty;
    }

    public void setWikitty(Wikitty wikitty) {
        this.wikitty = wikitty;
    }

    public String getPostUrl() {
        return this.getArgument(ARGS_KEY, "") + ".action";
    }

    protected Map<String, Object> formatArgs(Map<String, Object> args) {
        this.wikittyFieldMap = new HashMap();
        for (Map.Entry<String, Object> en : args.entrySet()) {
            if (!en.getKey().startsWith("Wikitty")) continue;
            String value = "";
            if (en.getValue() instanceof String[]) {
                for (String occu : (String[])en.getValue()) {
                    value = value + occu;
                }
            } else {
                value = String.valueOf(en.getValue());
            }
            if ("BINARY".equals(value) && this.uploadedFile != null) {
                try {
                    this.wikittyFieldMap.put(en.getKey(), FileUtil.fileToByte((File)this.uploadedFile));
                    this.uploadedFile.deleteOnExit();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Error while reading File uploaded as wikittyPubDataContent ", (Throwable)e);
                }
                continue;
            }
            this.wikittyFieldMap.put(en.getKey(), value);
        }
        return this.wikittyFieldMap;
    }

    protected void putIdArgs(String id) {
        ActionContext.getContext().getParameters().put(ARGS_KEY, Element.ELT_ID + ":" + id);
    }

    public String getMimeType() {
        if (this.wikitty.hasExtension("WikittyPubText")) {
            return WikittyPubTextHelper.getMimeType((Wikitty)this.wikitty);
        }
        return "";
    }
}

