/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyHook;

public class WikittyHookDTO
implements WikittyHook {
    @WikittyField(fqn="WikittyHook.name")
    protected String name;
    @WikittyField(fqn="WikittyHook.actionToHook")
    protected Set<String> actionToHook = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyHook.script")
    protected String script;
    @WikittyField(fqn="WikittyHook.mimetype")
    protected String mimetype;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        ++this.modificationCount;
    }

    public Set<String> getActionToHook() {
        return this.actionToHook;
    }

    public void setActionToHook(Set<String> actionToHook) {
        this.actionToHook = actionToHook == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(actionToHook);
        ++this.modificationCount;
    }

    public void addAllActionToHook(Set<String> actionToHook) {
        if (this.actionToHook == null) {
            this.actionToHook = new LinkedHashSet<String>();
        }
        this.actionToHook.addAll(actionToHook);
        ++this.modificationCount;
    }

    public void addActionToHook(String element) {
        if (this.actionToHook == null) {
            this.actionToHook = new LinkedHashSet<String>();
        }
        this.actionToHook.add(element);
        ++this.modificationCount;
    }

    public void removeActionToHook(String element) {
        this.actionToHook.remove(element);
        ++this.modificationCount;
    }

    public void clearActionToHook() {
        this.actionToHook.clear();
        ++this.modificationCount;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
        ++this.modificationCount;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
        ++this.modificationCount;
    }

    public WikittyHookDTO() {
    }

    public WikittyHookDTO(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String toString() {
        return "dto:" + this.getWikittyId() + ":" + this.getWikittyVersion();
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String getWikittyVersion() {
        String result = this.wikittyVersion;
        if (this.modificationCount > 0) {
            result = result + "." + this.modificationCount;
        }
        return result;
    }

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion = wikittyVersion;
        this.modificationCount = 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyHook)) {
            throw new WikittyException("Can't copy source object " + source + ". They are not of the same type");
        }
        WikittyHook sourceCopy = (WikittyHook)source;
        this.setName(sourceCopy.getName());
        Set actionToHook = sourceCopy.getActionToHook();
        if (actionToHook != null) {
            this.setActionToHook(new LinkedHashSet<String>(actionToHook));
        }
        this.setScript(sourceCopy.getScript());
        this.setMimetype(sourceCopy.getMimetype());
        this.setWikittyVersion(sourceCopy.getWikittyVersion());
    }
}

