package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.web.SecurityEntityEnum;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Mar 17 17:27:11 CET 2014")
public abstract class GeneratedSecurityRoleTopiaDao<E extends SecurityRole> extends AbstractTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) SecurityRole.class;
    }

    @Override
    public SecurityEntityEnum getTopiaEntityEnum() {
        return SecurityEntityEnum.SecurityRole;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.topiaid " +
                    " FROM securityUser main, securityrole_securityuser secondary " +
                    " WHERE main.topiaid=secondary.securityUser " +
                    " AND secondary.securityRole='" + entity.getTopiaId() + "'";
            List<SecurityUser> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", SecurityEntityEnum.SecurityUser.getImplementation())
                    .list();

            for (SecurityUser item : list) {
                item.removeSecurityRole(entity);
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Iterable<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SecurityRole.NAME, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SecurityRole.NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPermissionsContains(String v) {
        return forContains(SecurityRole.PERMISSIONS, v);
    }

    @Deprecated
    public E findContainsPermissions(String v) {
        return forPermissionsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsPermissions(String v) {
        return forPermissionsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == SecurityUser.class) {
            SecurityUserTopiaDao dao =
                topiaDaoSupplier.getDao(SecurityUser.class, SecurityUserTopiaDao.class);
            tmp = dao.forSecurityRoleContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SecurityUser.class, entity);
        if (!list.isEmpty()) {
            result.put(SecurityUser.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedSecurityRoleTopiaDao<E extends SecurityRole>
