package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper.TopiaSecurityEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TaasPrincipalDAOAbstract<E extends TaasPrincipal> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TaasPrincipal.class;
    }

    @Override
    public TopiaSecurityEntityEnum getTopiaEntityEnum() {
        return TopiaSecurityEntityEnum.TaasPrincipal;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<TaasUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from taasUser main, principals_users secondary " +
                    "where main.topiaid=secondary.users" +
                    " and secondary.principals='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(TaasUser.class)).list();

            for (TaasUser item : list) {
                item.removePrincipals(entity);
            }
        }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(TaasPrincipal.NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(TaasPrincipal.NAME, v);
        return result;
    }

    public E findContainsAuthorizations(TaasAuthorization v) throws TopiaException {
        E result = findContains(TaasPrincipal.AUTHORIZATIONS, v);
        return result;
    }

    public List<E> findAllContainsAuthorizations(TaasAuthorization v) throws TopiaException {
        List<E> result = findAllContains(TaasPrincipal.AUTHORIZATIONS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TaasUser.class) {
            TaasUserDAO dao = (TaasUserDAO)
                getContext().getDAO(TaasUser.class);
            tmp = dao.findAllContainsPrincipals(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(TaasUser.class, entity);
        if (!list.isEmpty()) {
            result.put(TaasUser.class, list);
        }

        return result;
    }

} //TaasPrincipalDAOAbstract<E extends TaasPrincipal>
