/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.jdbc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.sql.Driver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.jdbc.BeanJdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;
import org.nuiton.util.FileUtil;

public class JdbcConfigurationBuilder {
    private static final Log log = LogFactory.getLog(JdbcConfigurationBuilder.class);
    protected static final String TIMESTAMP = String.valueOf(System.nanoTime());

    public JdbcConfiguration forDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword, String jdbcDriverClassName) {
        try {
            Class<?> jdbcDriverClass = Class.forName(jdbcDriverClassName);
            if (Driver.class.isAssignableFrom(jdbcDriverClass)) {
                return this.forDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword, jdbcDriverClass);
            }
            throw new IllegalArgumentException(jdbcDriverClassName + " seems not to be a JDBC driver: it does not implement " + Driver.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("unable to find JDBC driver class " + jdbcDriverClassName + " in classpath", e);
        }
    }

    public JdbcConfiguration forDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword, Class<? extends Driver> jdbcDriverClass) {
        BeanJdbcConfiguration beanJdbcConfiguration = new BeanJdbcConfiguration();
        beanJdbcConfiguration.setJdbcConnectionUrl(jdbcConnectionUrl);
        beanJdbcConfiguration.setJdbcConnectionUser(jdbcConnectionUser);
        beanJdbcConfiguration.setJdbcConnectionPassword(jdbcConnectionPassword);
        beanJdbcConfiguration.setJdbcDriverClass(jdbcDriverClass);
        return beanJdbcConfiguration;
    }

    public JdbcConfiguration forDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword) {
        String guessedJdbcDriverClassName = this.guessJdbcDriverClassName(jdbcConnectionUrl);
        if (guessedJdbcDriverClassName == null) {
            throw new UnsupportedOperationException("unable to guess JDBC driver class name for URL " + jdbcConnectionUrl);
        }
        return this.forDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword, guessedJdbcDriverClassName);
    }

    public JdbcConfiguration forPostgresqlDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword) {
        return this.forDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword, this.getPostgreSqlJdbcDriverClassName());
    }

    public JdbcConfiguration forH2Database(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword) {
        return this.forDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword, this.getH2JdbcDriverClassName());
    }

    public JdbcConfiguration forH2Database(String jdbcConnectionUrl) {
        return this.forH2Database(jdbcConnectionUrl, "sa", "");
    }

    public JdbcConfiguration forH2Database(File file) {
        String jdbcConnectionUrl = "jdbc:h2:file:" + file.getAbsolutePath();
        return this.forH2Database(jdbcConnectionUrl);
    }

    public JdbcConfiguration forH2DatabaseInTempDirectory() {
        return this.forH2Database(Files.createTempDir());
    }

    public JdbcConfiguration forInMemoryH2Database() {
        throw new UnsupportedOperationException();
    }

    public JdbcConfiguration forTestDatabase(Class<?> testClass, String methodName) {
        String javaIoTmpDir = StandardSystemProperty.JAVA_IO_TMPDIR.value();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)javaIoTmpDir), (Object)("'" + StandardSystemProperty.JAVA_IO_TMPDIR.key() + "' is not defined in environment"));
        File tempDirectoryFile = new File(javaIoTmpDir);
        try {
            FileUtil.createDirectoryIfNecessary((File)tempDirectoryFile);
        }
        catch (IOException e) {
            throw new TopiaException(e);
        }
        String path = Joiner.on((String)File.separator).join((Object)TIMESTAMP, (Object)testClass.getName(), new Object[]{methodName, "h2"});
        File file = new File(tempDirectoryFile, path);
        JdbcConfiguration jdbcConfiguration = this.forH2Database(file);
        if (log.isDebugEnabled()) {
            log.debug((Object)("will store H2 tests data in " + jdbcConfiguration.getJdbcConnectionUrl()));
        }
        return jdbcConfiguration;
    }

    public String guessJdbcDriverClassName(String jdbcUrl) {
        String guessedJdbcDriverClassName = this.isDb2Url(jdbcUrl) ? this.getDb2JdbcDriverClassName() : (this.isDerbyUrl(jdbcUrl) ? this.getDerbyJdbcDriverClassName() : (this.isH2Url(jdbcUrl) ? this.getH2JdbcDriverClassName() : (this.isHsqlDbUrl(jdbcUrl) ? this.getHqlDbJdbcDriverClassName() : (this.isMysqlUrl(jdbcUrl) ? this.getMysqlJdbcDriverClassName() : (this.isMariaDbUrl(jdbcUrl) ? this.getMariaDbJdbcDriverClassName() : (this.isGoogleAppEngineUrl(jdbcUrl) ? this.getGooglaAppEngineJdbcDriverClassName() : (this.isOracleUrl(jdbcUrl) ? this.getOracleJdbcDriverClassName() : (this.isPostgreSqlUrl(jdbcUrl) ? this.getPostgreSqlJdbcDriverClassName() : (this.isJtdsUrl(jdbcUrl) ? this.getJdtsJdbcDriverClassName() : (this.isSqlServerUrl(jdbcUrl) ? this.getSqlServerJdbcDriverClassName() : (this.isSqliteUrl(jdbcUrl) ? this.getSqliteJdbcDriverClassName() : (this.isSqlDroidUrl(jdbcUrl) ? this.getSqlDroidJdbcDriverClassName() : null))))))))))));
        return guessedJdbcDriverClassName;
    }

    public String getDb2JdbcDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    public String getDerbyJdbcDriverClassName() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    public String getH2JdbcDriverClassName() {
        return "org.h2.Driver";
    }

    public String getHqlDbJdbcDriverClassName() {
        return "org.hsqldb.jdbcDriver";
    }

    public String getMysqlJdbcDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    public String getOracleJdbcDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    public String getGooglaAppEngineJdbcDriverClassName() {
        return "com.google.appengine.api.rdbms.AppEngineDriver";
    }

    public String getMariaDbJdbcDriverClassName() {
        return "org.mariadb.jdbc.Driver";
    }

    public String getPostgreSqlJdbcDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdtsJdbcDriverClassName() {
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    public String getSqlServerJdbcDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getSqliteJdbcDriverClassName() {
        return "org.sqlite.JDBC";
    }

    public String getSqlDroidJdbcDriverClassName() {
        return "org.sqldroid.SQLDroidDriver";
    }

    public boolean isDb2Url(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:db2:");
    }

    public boolean isSqlDroidUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:sqldroid:");
    }

    public boolean isSqliteUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:sqlite:");
    }

    public boolean isSqlServerUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:sqlserver:");
    }

    public boolean isJtdsUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:jtds:");
    }

    public boolean isPostgreSqlUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:postgresql:");
    }

    public boolean isOracleUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:oracle:");
    }

    public boolean isGoogleAppEngineUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:google:");
    }

    public boolean isMariaDbUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:mariadb:");
    }

    public boolean isMysqlUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:mysql:");
    }

    public boolean isHsqlDbUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:hsqldb:");
    }

    public boolean isH2Url(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:h2:");
    }

    public boolean isDerbyUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:derby:");
    }
}

