/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.j2r.types;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;
import org.nuiton.j2r.types.REXP;
import org.nuiton.j2r.types.RList;

public abstract class REXPAbstract
implements REXP {
    private Log log = LogFactory.getLog(REXPAbstract.class);
    protected String variable;
    protected Map<String, Object> attributes;
    protected REngine engine;
    protected List<String> names;
    protected String indexExceptionText = "Cannot perform operation, index is superior to size.\nIndex : %s\nSize : %s";
    protected String dataInconsistencyText = "There is an inconsistency between the local and distant data.\nLocal data size : %s\nDistant data size : %s";
    protected String noVariable = "No variable name given";

    @Override
    public void setAttributes(Map<String, Object> attributes) throws RException {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Map<String, Object> getAttributes() throws RException {
        if (this.engine.isAutoCommit().booleanValue()) {
            Integer attributeslength = (Integer)this.engine.eval(String.format("length(attributes(%s))", this.variable));
            for (int i = 0; i < attributeslength; ++i) {
                String key = (String)this.engine.eval(String.format("names(attributes(%s))[%s]", this.variable, i + 1));
                this.getAttribute(key);
            }
        }
        return this.attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getAttribute(String attribute) throws RException {
        if (this.engine.isAutoCommit().booleanValue()) {
            Object returnedAttribute;
            if (((Boolean)this.engine.eval("is.data.frame(" + String.format("attr(%s,\"%s\")", this.variable, attribute) + ")")).booleanValue()) {
                returnedAttribute = new RDataFrame(this.engine);
                ((RDataFrame)returnedAttribute).getFrom(String.format("attr(%s,\"%s\")", this.variable, attribute));
            } else if (((Boolean)this.engine.eval("is.list(" + String.format("attr(%s,\"%s\")", this.variable, attribute) + ")")).booleanValue()) {
                returnedAttribute = new RList(this.engine);
                ((RList)returnedAttribute).getFrom(String.format("attr(%s,\"%s\")", this.variable, attribute));
            } else {
                returnedAttribute = this.engine.eval(String.format("attr(%s,\"%s\")", this.variable, attribute));
            }
            if (returnedAttribute == null) throw new RException("Attribute does not exist");
            if (this.attributes.containsKey(attribute)) {
                this.attributes.remove(attribute);
                this.attributes.put(attribute, returnedAttribute);
                return this.attributes.get(attribute);
            } else {
                this.attributes.put(attribute, returnedAttribute);
            }
            return this.attributes.get(attribute);
        } else {
            if (this.attributes.containsKey(attribute)) return this.attributes.get(attribute);
            throw new RException("Attribute does not exist");
        }
    }

    @Override
    public void setAttribute(String attribute, Object value) throws RException {
        if (value instanceof String) {
            this.setAttribute(attribute, (String)value);
        } else if (value instanceof Double) {
            this.setAttribute(attribute, (Double)value);
        } else if (value instanceof Integer) {
            this.setAttribute(attribute, (Integer)value);
        } else if (value instanceof Boolean) {
            this.setAttribute(attribute, (Boolean)value);
        } else if (value instanceof REXP) {
            this.setAttribute(attribute, (REXP)value);
        } else {
            this.log.warn((Object)("This attribute is not valid : " + attribute + " ; " + value + ". It will not be processed"));
        }
    }

    public void setAttribute(String attribute, Double value) throws RException {
        this.engine.voidEval(String.format("attr(%s,\"%s\")<-%s", this.variable, attribute, value));
        this.putAttributeInData(attribute, value);
    }

    public void setAttribute(String attribute, Integer value) throws RException {
        this.engine.voidEval(String.format("attr(%s,\"%s\")<-%s", this.variable, attribute, String.format("as.integer(%s)", value)));
        this.putAttributeInData(attribute, value);
    }

    public void setAttribute(String attribute, Boolean value) throws RException {
        this.engine.voidEval(String.format("attr(%s,\"%s\")<-%s", this.variable, attribute, value.toString().toUpperCase()));
        this.putAttributeInData(attribute, value);
    }

    public void setAttribute(String attribute, String value) throws RException {
        this.engine.voidEval(String.format("attr(%s,\"%s\")<-%s", this.variable, attribute, "\"" + value + "\""));
        this.putAttributeInData(attribute, value);
    }

    public void setAttribute(String attribute, REXP value) throws RException {
        this.engine.voidEval(String.format("attr(%s,\"%s\")<-%s", this.variable, attribute, value.toRString()));
        this.putAttributeInData(attribute, value);
    }

    private void putAttributeInData(String attribute, Object value) {
        if (this.attributes.containsKey(attribute)) {
            this.attributes.remove(attribute);
            this.attributes.put(attribute, value);
        } else {
            this.attributes.put(attribute, value);
        }
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) throws RException {
        this.variable = variable;
        try {
            this.engine.voidEval(this.toRString());
        }
        catch (RException eee) {
            throw new RException("An error occured while trying to assign the list in R", eee);
        }
    }

    public List<String> getNames() throws RException {
        if (this.engine.isAutoCommit().booleanValue()) {
            String[] namesArray = (String[])this.engine.eval(String.format("names(%s)", this.variable));
            this.checkX(namesArray.length);
            this.names.clear();
            this.names.addAll(Arrays.asList(namesArray));
            return this.names;
        }
        return this.names;
    }

    public String getName(int x) throws RException {
        if (x < this.names.size()) {
            String name;
            if (this.engine.isAutoCommit().booleanValue() && (name = (String)this.engine.eval(String.format("names(%s)[%s]", this.variable, x + 1))) != null && !name.equals("")) {
                this.names.set(x, name);
            }
        } else {
            throw new IndexOutOfBoundsException(String.format(this.indexExceptionText, x, this.names.size()));
        }
        return this.names.get(x);
    }

    protected void checkVariable() throws RException {
        if (this.variable == null || this.variable.equals("")) {
            throw new RException(this.noVariable);
        }
    }

    public void setEngine(REngine engine) throws RException {
        this.engine = engine;
        try {
            engine.eval(this.toRString());
        }
        catch (RException eee) {
            throw new RException("Cannot assign the data.frame to the new REngine", eee);
        }
    }

    public REngine getEngine() {
        return this.engine;
    }

    public void setNames(List<String> names) throws RException {
        this.checkX(names.size());
        this.names = names;
        StringBuilder namesString = new StringBuilder("");
        for (int i = 0; i < this.names.size(); ++i) {
            if (i != 0) {
                namesString.append(",");
            }
            namesString.append("\"");
            namesString.append(names.get(i));
            namesString.append("\"");
        }
        String rexp = String.format("names(%s)<-c(%s)", this.variable, namesString);
        this.engine.voidEval(rexp);
    }

    public void setName(int x, String name) throws RException {
        this.checkX(x);
        for (int i = 0; i <= x; ++i) {
            try {
                this.names.get(i);
                if (x != i) continue;
                this.names.set(x, name);
                continue;
            }
            catch (IndexOutOfBoundsException eee) {
                if (x == i) {
                    this.names.add(name);
                    continue;
                }
                this.names.add(null);
            }
        }
        String rexp = String.format("names(%s)[%s]<-\"%s\"", this.variable, x + 1, name);
        this.engine.voidEval(rexp);
    }
}

