/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.DimensionHelper;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.SemanticList;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.math.matrix.SubMatrix;
import org.nuiton.util.ArrayUtil;

public abstract class AbstractMatrixND
implements MatrixND {
    private static final long serialVersionUID = -6838751468730930727L;
    private static Log log = LogFactory.getLog(AbstractMatrixND.class);
    protected transient DimensionHelper dimHelper = new DimensionHelper();
    protected transient MatrixFactory factory = null;
    protected String name = "";
    protected String[] dimNames = null;
    protected int[] dim = null;
    protected List<?>[] semantics = null;
    @Deprecated
    protected double defaultValue = 0.0;
    public static final char CSV_SEPARATOR = ';';
    protected static final String NUMBER_REGEX = " *[+-]?[0-9]*\\.?[0-9]+([eE][+-]?[0-9]+)? *";
    protected static final Pattern NUMBER = Pattern.compile(" *[+-]?[0-9]*\\.?[0-9]+([eE][+-]?[0-9]+)? *");

    protected void init(int[] dim) {
        this.dim = new int[dim.length];
        System.arraycopy(dim, 0, this.dim, 0, dim.length);
        this.semantics = new List[dim.length];
        this.dimNames = new String[dim.length];
        Arrays.fill(this.dimNames, "");
    }

    protected AbstractMatrixND(MatrixFactory factory) {
        this.factory = factory;
    }

    public AbstractMatrixND(MatrixFactory factory, int[] dim) {
        this(factory);
        this.init(dim);
        for (int i = 0; i < this.getDimCount(); ++i) {
            this.semantics[i] = Collections.nCopies(dim[i], null);
        }
    }

    public AbstractMatrixND(MatrixFactory factory, List<?>[] semantics) {
        this(factory);
        int i;
        int[] dim = new int[semantics.length];
        for (i = 0; i < dim.length; ++i) {
            dim[i] = semantics[i] == null ? 0 : semantics[i].size();
        }
        this.init(dim);
        for (i = 0; i < this.getDimCount(); ++i) {
            this.setSemantic(i, semantics[i]);
        }
    }

    public AbstractMatrixND(MatrixFactory factory, String name, int[] dim) {
        this(factory, dim);
        this.setName(name);
    }

    public AbstractMatrixND(MatrixFactory factory, String name, int[] dim, String[] dimNames) {
        this(factory, name, dim);
        for (int i = 0; dimNames != null && i < dimNames.length; ++i) {
            this.setDimensionName(i, dimNames[i]);
        }
    }

    public AbstractMatrixND(MatrixFactory factory, String name, List<?>[] semantics) {
        this(factory, semantics);
        this.setName(name);
    }

    public AbstractMatrixND(MatrixFactory factory, String name, List<?>[] semantics, String[] dimNames) {
        this(factory, name, semantics);
        for (int i = 0; dimNames != null && i < dimNames.length; ++i) {
            this.setDimensionName(i, dimNames[i]);
        }
    }

    @Override
    public MatrixND copy() {
        MatrixND result = this.getFactory().create(this);
        return result;
    }

    @Override
    public MatrixND clone() {
        return this.copy();
    }

    @Override
    public MatrixFactory getFactory() {
        return this.factory;
    }

    @Override
    public List[] getSemantics() {
        return Arrays.copyOf(this.semantics, this.semantics.length);
    }

    @Override
    @Deprecated
    public List getSemantics(int dim) {
        return this.getSemantic(dim);
    }

    @Override
    public List getSemantic(int dim) {
        return this.semantics[dim];
    }

    @Override
    @Deprecated
    public <E> void setSemantics(int dim, List<E> sem) {
        this.setSemantic(dim, sem);
    }

    @Override
    public <E> void setSemantic(int dim, List<E> sem) {
        if (!(sem instanceof SemanticList)) {
            sem = new SemanticList<E>(sem);
        }
        this.semantics[dim] = sem;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getDimensionNames() {
        return this.dimNames;
    }

    @Override
    public void setDimensionNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.setDimensionName(i, names[i]);
        }
    }

    @Override
    @Deprecated
    public String[] getDimensionName() {
        return this.getDimensionNames();
    }

    @Override
    @Deprecated
    public void setDimensionName(String[] names) {
        this.setDimensionNames(names);
    }

    @Override
    public void setDimensionName(int dim, String name) {
        this.dimNames[dim] = name;
    }

    @Override
    public String getDimensionName(int dim) {
        return this.dimNames[dim];
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        int nbelem = 1;
        for (int i = 0; i < this.getDimCount(); ++i) {
            nbelem *= this.getDim(i);
        }
        double[] data = new double[nbelem];
        int i = 0;
        MatrixIterator mi = this.iterator();
        while (mi.next()) {
            data[i++] = mi.getValue();
        }
        return MatrixHelper.maxOccurrence(data);
    }

    @Override
    @Deprecated
    public int getNbDim() {
        return this.getDimCount();
    }

    @Override
    public int getDimCount() {
        return this.dim.length;
    }

    @Override
    public int[] getDim() {
        return this.dim;
    }

    @Override
    public int getDim(int d) {
        return this.dim[d];
    }

    @Override
    public long size() {
        return MatrixHelper.getVectorSize(this.getDim());
    }

    @Override
    public MatrixND map(MapFunction f) {
        MatrixIterator i = this.iterator();
        while (i.next()) {
            i.setValue(f.apply(i.getValue()));
        }
        return this;
    }

    @Override
    public double getValue(Object[] coordinates) {
        List<?>[] sems = this.semantics;
        return this.getValue(MatrixHelper.semanticsToDimension(sems, coordinates));
    }

    @Override
    public double getValue(Object x) {
        return this.getValue(this.dimHelper.get(x));
    }

    @Override
    public double getValue(Object x, Object y) {
        return this.getValue(this.dimHelper.get(x, y));
    }

    @Override
    public double getValue(Object x, Object y, Object z) {
        return this.getValue(this.dimHelper.get(x, y, z));
    }

    @Override
    public double getValue(Object x, Object y, Object z, Object t) {
        return this.getValue(this.dimHelper.get(x, y, z, t));
    }

    @Override
    public double getValue(int x) {
        return this.getValue(this.dimHelper.get(x));
    }

    @Override
    public double getValue(int x, int y) {
        return this.getValue(this.dimHelper.get(x, y));
    }

    @Override
    public double getValue(int x, int y, int z) {
        return this.getValue(this.dimHelper.get(x, y, z));
    }

    @Override
    public double getValue(int x, int y, int z, int t) {
        return this.getValue(this.dimHelper.get(x, y, z, t));
    }

    @Override
    public void setValue(Object[] coordinates, double d) {
        this.setValue(MatrixHelper.semanticsToDimension(this.semantics, coordinates), d);
    }

    @Override
    public void setValue(Object x, double d) {
        this.setValue(this.dimHelper.get(x), d);
    }

    @Override
    public void setValue(Object x, Object y, double d) {
        this.setValue(this.dimHelper.get(x, y), d);
    }

    @Override
    public void setValue(Object x, Object y, Object z, double d) {
        this.setValue(this.dimHelper.get(x, y, z), d);
    }

    @Override
    public void setValue(Object x, Object y, Object z, Object t, double d) {
        this.setValue(this.dimHelper.get(x, y, z, t), d);
    }

    @Override
    public void setValue(int x, double d) {
        this.setValue(this.dimHelper.get(x), d);
    }

    @Override
    public void setValue(int x, int y, double d) {
        this.setValue(this.dimHelper.get(x, y), d);
    }

    @Override
    public void setValue(int x, int y, int z, double d) {
        this.setValue(this.dimHelper.get(x, y, z), d);
    }

    @Override
    public void setValue(int x, int y, int z, int t, double d) {
        this.setValue(this.dimHelper.get(x, y, z, t), d);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MatrixND && this.equals((MatrixND)o);
    }

    public boolean equals(MatrixND mat) {
        boolean result = true;
        if (mat != this) {
            result = result && this.getName().equals(mat.getName());
            boolean bl = result = result && this.equalsValues(mat);
            if (result) {
                for (int i = 0; result && i < this.getDimCount(); ++i) {
                    String dimName1 = this.getDimensionName(i);
                    String dimName2 = mat.getDimensionName(i);
                    result = ObjectUtils.equals((Object)dimName1, (Object)dimName2);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("dimName1(" + dimName1 + ")==dimName2(" + dimName2 + ")=" + result));
                    }
                    List sem1 = this.getSemantic(i);
                    List sem2 = mat.getSemantic(i);
                    boolean bl2 = result = result && ObjectUtils.equals((Object)sem1, (Object)sem2);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("sem1(" + sem1 + ")==sem2(" + sem2 + ")=" + result));
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("result=" + result));
            }
        }
        return result;
    }

    @Override
    public boolean equalsValues(MatrixND mat) {
        boolean result = true;
        boolean bl = result = result && MatrixHelper.sameDimension(this.getDim(), mat.getDim());
        if (result) {
            MatrixIterator i = mat.iterator();
            while (result && i.next()) {
                double v2;
                double v1 = i.getValue();
                boolean bl2 = result = v1 == (v2 = this.getValue(i.getCoordinates()));
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("v1(" + v1 + ")==v2(" + v2 + ")=" + result));
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("dimensions = [\n");
        for (int i = 0; i < this.getDim().length; ++i) {
            result.append(this.getDim()[i] + ",");
        }
        result.append("\n]\nmatrice = [\n");
        MatrixIterator i = this.iterator();
        while (i.next()) {
            result.append(i.getValue() + ",");
        }
        result.append("\n]\n");
        return result.toString();
    }

    @Override
    public List<?> toList() {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        MatrixIterator i = this.iterator();
        while (i.next()) {
            int[] coord = i.getCoordinates();
            double value = i.getValue();
            List<Serializable> tmp = result;
            for (int dim = 0; dim < coord.length - 1; ++dim) {
                while (tmp.size() <= coord[dim]) {
                    tmp.add(new ArrayList());
                }
                tmp = (List)tmp.get(coord[dim]);
            }
            while (tmp.size() <= coord[coord.length - 1]) {
                tmp.add(NumberUtils.DOUBLE_ZERO);
            }
            tmp.set(coord[coord.length - 1], Double.valueOf(value));
        }
        return result;
    }

    @Override
    public void fromList(List<?> list) {
        ArrayIntList dim = new ArrayIntList();
        List tmp = list;
        while (tmp.get(tmp.size() - 1) instanceof List) {
            dim.add(tmp.size());
            tmp = (List)tmp.get(tmp.size() - 1);
        }
        dim.add(tmp.size());
        MatrixND mat = this.getFactory().create(dim.toArray());
        MatrixIterator i = mat.iterator();
        while (i.next()) {
            int[] coord = i.getCoordinates();
            tmp = list;
            for (int d = 0; d < coord.length - 1; ++d) {
                tmp = (List)tmp.get(coord[d]);
            }
            Double value = (Double)tmp.get(coord[coord.length - 1]);
            i.setValue(value);
        }
        this.paste(mat);
    }

    public boolean isValidCoordinates(int[] pos) {
        return MatrixHelper.isValidCoordinates(this.getDim(), pos);
    }

    public boolean isValidCoordinates(Object[] pos) {
        List[] sems = this.semantics;
        return MatrixHelper.isValidCoordinates(sems, pos);
    }

    @Override
    public double sumAll() {
        double result = 0.0;
        MatrixIterator i = this.iteratorNotZero();
        while (i.next()) {
            result += i.getValue();
        }
        return result;
    }

    @Override
    public MatrixND sumOverDim(int dim) {
        return this.sumOverDim(dim, this.getDim(dim));
    }

    @Override
    public MatrixND sumOverDim(int dim, int step) {
        int[] matDim = this.getDim();
        if (step < 0) {
            step = matDim[dim];
        }
        if (step <= 1) {
            return this.copy();
        }
        int nbDim = (int)Math.ceil((double)matDim[dim] / (double)step);
        List[] sems = new List[matDim.length];
        System.arraycopy(this.semantics, 0, sems, 0, matDim.length);
        ArrayList<Integer> sem = new ArrayList<Integer>(nbDim);
        for (int i = 0; i < nbDim; ++i) {
            sem.add(i);
        }
        sems[dim] = sem;
        MatrixND result = this.getFactory().create(this.getName(), sems, this.getDimensionNames());
        MatrixIterator i = this.iteratorNotZero();
        while (i.hasNext()) {
            i.next();
            double val = i.getValue();
            int[] pos = i.getCoordinates();
            pos[dim] = pos[dim] / step;
            double oldVal = result.getValue(pos);
            result.setValue(pos, oldVal + val);
        }
        return result;
    }

    @Override
    public MatrixND sumOverDim(int dim, int start, int nb) {
        int[] matDim = this.getDim();
        List[] sems = new List[matDim.length];
        System.arraycopy(this.semantics, 0, sems, 0, matDim.length);
        sems[dim] = new ArrayList(sems[dim]);
        ArrayList newElem = new ArrayList();
        for (int i = 0; i < nb; ++i) {
            newElem.add(sems[dim].remove(start));
        }
        sems[dim].add(start, newElem);
        MatrixND result = this.getFactory().create(this.getName(), sems, this.getDimensionNames());
        int end = start + nb;
        MatrixIterator i = this.iteratorNotZero();
        while (i.hasNext()) {
            i.next();
            double val = i.getValue();
            int[] pos = i.getCoordinates();
            if (start < pos[dim] && pos[dim] < end) {
                pos[dim] = start;
            } else if (end <= pos[dim]) {
                int n = dim;
                pos[n] = pos[n] - (nb - 1);
            }
            double oldVal = result.getValue(pos);
            result.setValue(pos, oldVal + val);
        }
        return result;
    }

    @Override
    public double meanAll() {
        double sum = this.sumAll();
        double number = this.size();
        double result = sum / number;
        return result;
    }

    @Override
    public MatrixND meanOverDim(int dim) {
        return this.meanOverDim(dim, this.getDim(dim));
    }

    @Override
    public MatrixND meanOverDim(int dim, int step) {
        int initialDimSize = this.getDim(dim);
        if (step < 0) {
            step = initialDimSize;
        } else if (step <= 1) {
            return this.getFactory().create(this);
        }
        int dimSize = initialDimSize / step;
        int residual = initialDimSize % step;
        MatrixND result = this.sumOverDim(dim, step);
        MatrixIterator i = result.iteratorNotZero();
        while (i.hasNext()) {
            i.next();
            int[] pos = i.getCoordinates();
            double divisor = step;
            if (pos[dim] >= dimSize) {
                divisor = residual;
            }
            if (divisor == 1.0) continue;
            double val = i.getValue();
            double newVal = val / divisor;
            i.setValue(newVal);
        }
        return result;
    }

    @Override
    public MatrixND cut(int dim, int[] toCut) {
        throw new UnsupportedOperationException("M\u00e9thode non implant\u00e9e");
    }

    @Override
    public MatrixND paste(MatrixND mat) {
        return this.paste(new int[this.getDimCount()], mat);
    }

    @Override
    public MatrixND paste(int[] origin, MatrixND mat) {
        if (mat != null) {
            MatrixIterator mi = mat.iterator();
            while (mi.next()) {
                int[] coordinates = ArrayUtil.sum((int[])origin, (int[])mi.getCoordinates());
                if (!this.isValidCoordinates(coordinates)) continue;
                this.setValue(coordinates, mi.getValue());
            }
        }
        return this;
    }

    @Override
    public MatrixND pasteSemantics(MatrixND mat) {
        if (mat != null) {
            MatrixIterator mi = mat.iterator();
            while (mi.next()) {
                Object[] sems = mi.getSemanticsCoordinates();
                if (!MatrixHelper.isValidCoordinates(this.getSemantics(), sems)) continue;
                this.setValue(sems, mi.getValue());
            }
        }
        return this;
    }

    @Override
    public MatrixND getSubMatrix(int dim, int start, int nb) {
        if (dim < 0) {
            dim = this.getDimCount() + dim;
        }
        if (start < 0) {
            start = this.getDim(dim) + start;
        }
        if (nb <= 0) {
            nb = this.getDim(dim) - start;
        }
        return new SubMatrix(this, dim, start, nb);
    }

    @Override
    public MatrixND getSubMatrix(int dim, Object start, int nb) {
        int begin = MatrixHelper.indexOf(this.getSemantics(), dim, start);
        return this.getSubMatrix(dim, begin, nb);
    }

    public MatrixND getSubMatrixOnSemantic(int dim, Object ... elem) {
        MatrixND result = this.getSubMatrix(dim, elem);
        return result;
    }

    @Override
    public MatrixND getSubMatrix(int dim, Object ... elem) {
        int[] ielem = new int[elem.length];
        for (int i = 0; i < ielem.length; ++i) {
            ielem[i] = MatrixHelper.indexOf(this.getSemantics(), dim, elem[i]);
        }
        return this.getSubMatrix(dim, ielem);
    }

    @Override
    public MatrixND getSubMatrix(Object[] ... elems) {
        if (elems.length != this.dim.length) {
            throw new IllegalArgumentException(String.format("Can't get sub matrix with different dimension count (expected: %d, got %d)", this.dim.length, elems.length));
        }
        MatrixND result = this;
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i] == null) continue;
            result = result.getSubMatrix(i, elems[i]);
        }
        return result;
    }

    @Override
    public MatrixND getSubMatrix(int dim, int[] elem) {
        return new SubMatrix(this, dim, elem);
    }

    @Override
    public MatrixND getSubMatrix(int[] ... elems) {
        if (elems.length != this.dim.length) {
            throw new IllegalArgumentException(String.format("Can't get sub matrix with different dimension count (expected: %d, got %d)", this.dim.length, elems.length));
        }
        AbstractMatrixND result = this;
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i] == null) continue;
            result = new SubMatrix(result, i, elems[i]);
        }
        return result;
    }

    @Override
    public MatrixND add(MatrixND m) {
        MatrixIterator i = m.iteratorNotZero();
        while (i.next()) {
            int[] pos = i.getCoordinates();
            double val = this.getValue(pos);
            this.setValue(pos, val + i.getValue());
        }
        return this;
    }

    @Override
    public MatrixND minus(MatrixND m) {
        MatrixIterator i = m.iteratorNotZero();
        while (i.next()) {
            int[] pos = i.getCoordinates();
            double val = this.getValue(pos);
            this.setValue(pos, val - i.getValue());
        }
        return this;
    }

    @Override
    public MatrixND transpose() {
        MatrixND result = null;
        if (this.getDimCount() > 2) {
            throw new MatrixException("La transpose ne peut-\u00eatre fait que sur une matrice ayant 2 dimensions ou moins");
        }
        if (this.getDimCount() == 1) {
            result = this.getFactory().create(this.getName(), new List[]{Collections.nCopies(1, null), this.getSemantic(0)}, new String[]{"Dimension 0", this.getDimensionName(0)});
            for (int x = 0; x < this.getDim(0); ++x) {
                result.setValue(0, x, this.getValue(x));
            }
        } else {
            result = this.getFactory().create(this.getName(), new List[]{this.getSemantic(1), this.getSemantic(0)}, new String[]{this.getDimensionName(1), this.getDimensionName(0)});
            for (int x = 0; x < this.getDim(0); ++x) {
                for (int y = 0; y < this.getDim(1); ++y) {
                    result.setValue(y, x, this.getValue(x, y));
                }
            }
        }
        return result;
    }

    @Override
    public MatrixND reduce() {
        return this.reduce(1);
    }

    @Override
    public MatrixND reduceDims(int ... dims) {
        Arrays.sort(dims);
        int[] correspondance = new int[this.getDimCount()];
        ArrayList<Object> sem = new ArrayList<Object>();
        ArrayList<String> dimName = new ArrayList<String>();
        int minNbDim = 1;
        for (int j = this.getDimCount() - 1; j >= 0; --j) {
            if (this.getDim(j) <= 1 && Arrays.binarySearch(dims, j) >= 0 && j >= minNbDim) continue;
            correspondance[sem.size()] = j;
            sem.add(this.getSemantic(j));
            dimName.add(this.getDimensionName(j));
            --minNbDim;
        }
        MatrixND result = this.reduce(dimName, sem, correspondance);
        return result;
    }

    @Override
    public MatrixND reduce(int minNbDim) {
        int[] correspondance = new int[this.getDimCount()];
        ArrayList<Object> sem = new ArrayList<Object>();
        ArrayList<String> dimName = new ArrayList<String>();
        for (int j = this.getDimCount() - 1; j >= 0; --j) {
            if (this.getDim(j) <= 1 && j >= minNbDim) continue;
            correspondance[sem.size()] = j;
            sem.add(this.getSemantic(j));
            dimName.add(this.getDimensionName(j));
            --minNbDim;
        }
        MatrixND result = this.reduce(dimName, sem, correspondance);
        return result;
    }

    protected MatrixND reduce(List<?> dimName, List<Object> sem, int[] correspondance) {
        int nbDim = sem.size();
        List[] newSemantics = new List[nbDim];
        String[] newDimNames = new String[nbDim];
        int[] tmpcorrespondance = new int[nbDim];
        for (int i = 0; i < nbDim; ++i) {
            newSemantics[i] = (List)sem.get(nbDim - 1 - i);
            newDimNames[i] = (String)dimName.get(nbDim - 1 - i);
            tmpcorrespondance[i] = correspondance[nbDim - 1 - i];
        }
        correspondance = tmpcorrespondance;
        MatrixND result = this.getFactory().create(this.getName(), newSemantics, newDimNames);
        int[] newCoordinates = new int[result.getDimCount()];
        MatrixIterator mi = this.iteratorNotZero();
        while (mi.next()) {
            int[] oldCoordinates = mi.getCoordinates();
            for (int i = 0; i < newCoordinates.length; ++i) {
                newCoordinates[i] = oldCoordinates[correspondance[i]];
            }
            result.setValue(newCoordinates, mi.getValue());
        }
        return result;
    }

    @Override
    public MatrixND mult(MatrixND m) throws MatrixException {
        if (this.getDimCount() > 2 || m.getDimCount() > 2) {
            throw new MatrixException("La multiplication de matrice n'est pas applicable aux matrices de plus de 2 dimensions");
        }
        if (this.getDim(1) != m.getDim(0)) {
            throw new MatrixException("Le nombre de colonnes de la matrice m1 doit etre egal au nombre de lignes de la matrice m2");
        }
        MatrixND result = this.getFactory().create(new int[]{this.getDim(0), m.getDim(1)});
        for (int x = 0; x < this.getDim(0); ++x) {
            for (int y = 0; y < m.getDim(1); ++y) {
                double d = this.getValue(x, 0) * m.getValue(0, y);
                for (int k = 1; k < this.getDim(1); ++k) {
                    d += this.getValue(x, k) * m.getValue(k, y);
                }
                result.setValue(x, y, d);
            }
        }
        return result;
    }

    @Override
    public MatrixND mults(final double d) {
        this.map(new MapFunction(){

            @Override
            public double apply(double val) {
                return val * d;
            }
        });
        return this;
    }

    @Override
    public MatrixND divs(final double d) {
        this.map(new MapFunction(){

            @Override
            public double apply(double val) {
                return val / d;
            }
        });
        return this;
    }

    @Override
    public MatrixND adds(final double d) {
        this.map(new MapFunction(){

            @Override
            public double apply(double val) {
                return val + d;
            }
        });
        return this;
    }

    @Override
    public MatrixND minuss(final double d) {
        this.map(new MapFunction(){

            @Override
            public double apply(double val) {
                return val - d;
            }
        });
        return this;
    }

    @Override
    @Deprecated
    public boolean isSupportedCSV() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importCSV(Reader reader, int[] origin) throws IOException {
        BufferedReader bReader = new BufferedReader(reader);
        bReader.mark(1);
        char firstChar = (char)bReader.read();
        bReader.reset();
        if (firstChar == '[') {
            this.importCSVND(bReader, origin);
            return;
        }
        int rowsCount = 0;
        ArrayList<Double> row = new ArrayList<Double>();
        StringBuffer number = new StringBuffer(20);
        boolean stop = false;
        int c = bReader.read();
        while (!stop) {
            if (c == -1) {
                stop = true;
            }
            if (c != 32) {
                if (c == 59) {
                    if (NUMBER.matcher(number.toString()).matches()) {
                        Double val = Double.valueOf(number.toString());
                        row.add(val);
                    }
                    number.setLength(0);
                } else if (c == -1 || c == 10 || c == 13) {
                    if (NUMBER.matcher(number.toString()).matches()) {
                        Double val = Double.valueOf(number.toString());
                        row.add(val);
                    }
                    number.setLength(0);
                    if (!row.isEmpty()) {
                        if (this.getDimCount() == 1) {
                            int columnNumber = origin[0];
                            for (Double value : row) {
                                if (columnNumber >= this.getDim(0)) continue;
                                this.setValue(new int[]{columnNumber++}, (double)value);
                            }
                        } else {
                            if (this.getDim().length != 2) throw new MatrixException("Can't import matrix with more than 2 dimensions.");
                            MatrixND matrix = this.getFactory().create(new int[]{1, row.size()});
                            int columnNumber = 0;
                            for (Double value : row) {
                                matrix.setValue(new int[]{0, columnNumber++}, (double)value);
                            }
                            this.paste(new int[]{origin[0] + rowsCount, origin[1]}, matrix);
                            ++rowsCount;
                            row.clear();
                        }
                    }
                } else {
                    number.append((char)c);
                }
            }
            c = bReader.read();
        }
    }

    @Override
    public void importCSV(Reader reader, int[] origin, String matrixName) throws IOException {
        this.importCSV(reader, origin);
        this.setName(matrixName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importCSV(File file, int[] origin) throws IOException {
        Reader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String matrixName = file.getName();
            if (matrixName.lastIndexOf(46) != -1) {
                matrixName = matrixName.substring(0, matrixName.lastIndexOf(46));
            }
            this.importCSV(reader, origin, matrixName);
        }
        finally {
            block10: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        if (!log.isErrorEnabled()) break block10;
                        log.error((Object)"Can't close reader", (Throwable)ex);
                    }
                }
            }
        }
    }

    protected void importCSVND(Reader reader, int[] origin) throws IOException {
        MatrixND matrix = MatrixFactory.getInstance().create(reader);
        this.pasteSemantics(matrix);
    }

    @Override
    public void exportCSV(Writer writer, boolean withSemantics) throws IOException {
        if (this.getDimCount() <= 2) {
            this.exportCSV2D(writer, withSemantics);
        } else {
            this.exportCSVND(writer, withSemantics);
        }
    }

    protected void exportCSV2D(Writer writer, boolean withSemantics) throws IOException {
        int columnsCount;
        int dimsCount = this.getDimCount();
        int rowsCount = dimsCount == 1 ? 1 : this.getDim(0);
        int n = columnsCount = dimsCount == 1 ? this.getDim(0) : this.getDim(1);
        if (withSemantics) {
            List listSemantics = this.getSemantic(dimsCount - 1);
            writer.append(dimsCount == 2 ? " ;" : "");
            for (Object semantic : listSemantics) {
                writer.append("\"" + semantic + "\"" + ';');
            }
            writer.append("\n");
        }
        for (int rowNb = 0; rowNb < rowsCount; ++rowNb) {
            if (withSemantics && dimsCount == 2) {
                Object semantic = this.getSemantic(0).get(rowNb);
                writer.append("\"" + semantic + "\"" + ';');
            }
            for (int columnNb = 0; columnNb < columnsCount; ++columnNb) {
                int[] nArray;
                if (dimsCount == 1) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = columnNb;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = rowNb;
                    nArray = nArray3;
                    nArray3[1] = columnNb;
                }
                int[] coordinates = nArray;
                writer.append(this.getValue(coordinates) + "" + ';');
            }
            writer.append("\n");
        }
    }

    @Override
    public void exportCSVND(Writer writer, boolean withSemantics) throws IOException {
        SemanticMapper mapper = MatrixFactory.getSemanticMapper();
        writer.append(Arrays.toString(this.getDim())).append("\n");
        for (List semantic : this.getSemantics()) {
            Object first;
            if (semantic != null && (first = semantic.get(0)) != null) {
                writer.append(mapper.getTypeName(first));
                writer.append(':');
                Iterator itValue = semantic.iterator();
                while (itValue.hasNext()) {
                    Object value = itValue.next();
                    writer.append(mapper.getValueId(value));
                    if (!itValue.hasNext()) continue;
                    writer.append(',');
                }
            }
            writer.append('\n');
        }
        MatrixIterator matrixIterator = this.iterator();
        while (matrixIterator.hasNext()) {
            matrixIterator.next();
            int[] coordinates = matrixIterator.getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                writer.append(String.valueOf(coordinates[i]));
                writer.append(';');
            }
            writer.append(String.valueOf(matrixIterator.getValue()));
            writer.append('\n');
        }
    }
}

