/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.api;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.jpa.api.JpaEntity;

public class JpaEntities {
    public static <E extends JpaEntity> E findById(Iterable<E> entities, String id) {
        JpaEntity result;
        if (entities == null) {
            result = null;
        } else {
            Optional eOptional = Iterables.tryFind(entities, JpaEntities.entityHasId(id));
            result = (JpaEntity)eOptional.orNull();
        }
        return (E)result;
    }

    public static Function<JpaEntity, String> getIdFunction() {
        return new GetIdFunction();
    }

    public static boolean isEntityHasId(JpaEntity entity, String id) {
        boolean result = JpaEntities.entityHasId(id).apply((Object)entity);
        return result;
    }

    public static boolean isEntityHasId(JpaEntity entity) {
        boolean result = JpaEntities.entityHasId().apply((Object)entity);
        return result;
    }

    public static boolean isEntityHasNoId(JpaEntity entity) {
        boolean result = JpaEntities.entityHasNoId().apply((Object)entity);
        return result;
    }

    public static Predicate<JpaEntity> entityHasId(String id) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)id), JpaEntities.getIdFunction());
    }

    public static Predicate<JpaEntity> entityHasId() {
        return Predicates.compose((Predicate)Predicates.notNull(), JpaEntities.getIdFunction());
    }

    public static Predicate<JpaEntity> entityHasNoId() {
        return Predicates.compose((Predicate)Predicates.equalTo(null), JpaEntities.getIdFunction());
    }

    public static <E extends JpaEntity> Comparator<E> arbitraryComparator() {
        return new ArbitraryComparator();
    }

    public static class ArbitraryComparator<E extends JpaEntity>
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(E x, E y) {
            return ObjectUtils.compare((Comparable)((Object)x.getId()), (Comparable)((Object)y.getId()));
        }
    }

    public static class GetIdFunction
    implements Function<JpaEntity, String> {
        public String apply(JpaEntity entity) {
            return entity.getId();
        }
    }
}

