package org.nuiton.jaxx.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-jaxx-plugin.<br/> Call <pre>  mvn jaxx:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Nov 13 11:38:25 CET 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.nuiton.jaxx:maven-jaxx-plugin:2.0.0-beta-1", 0 );
        append( sb, "", 0 );

        append( sb, "JAXX Maven plugin", 0 );
        append( sb, "Maven 2 plugin to generate java sources from JAXX files.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "generate".equals( goal ) )
        {
            append( sb, "jaxx:generate", 0 );
            append( sb, "Generates some java code from jaxx files.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addCompileClassPath (Default: false)", 2 );
                append( sb, "flag to include in compiler classpath the compile class-path (can only be used in a test phase).\nBy default, false.\n", 3 );
                append( sb, "", 0 );

                append( sb, "addLogger (Default: true)", 2 );
                append( sb, "flag to add logger to each generated jaxx file.\nBy default, always add it.\n", 3 );
                append( sb, "", 0 );

                append( sb, "addProjectClassPath (Default: false)", 2 );
                append( sb, "flag to include in compiler classpath the project compile classpath.\nBy default, false.\n", 3 );
                append( sb, "", 0 );

                append( sb, "addResourcesToClassPath (Default: false)", 2 );
                append( sb, "flag to include in compiler classpath the java resources directories (src and outJava).\nBy default, false.\n", 3 );
                append( sb, "", 0 );

                append( sb, "addSourcesToClassPath (Default: false)", 2 );
                append( sb, "flag to include in compiler classpath the java sources directories (src and outJava).\nBy default, false.\n", 3 );
                append( sb, "", 0 );

                append( sb, "beanInfoSearchPath", 2 );
                append( sb, "extra path to be added in Introspector.setBeanInfoSearchPath().\nadd beanInfoSearchPath to be registred by BeanInfoUtil.addJaxxBeanInfoPath()\n\nand then will be use by DefaultInitializer.initialize().\n\n\nThis permit to use real beanInfo of imported graphic libraries.\n", 3 );
                append( sb, "", 0 );

                append( sb, "compilerFQN (Default: jaxx.compiler.JAXXCompiler)", 2 );
                append( sb, "Le compilateur \u00e0 utiliser (par d\u00e9faut celui de Swing)", 3 );
                append( sb, "", 0 );

                append( sb, "defaultDecoratorFQN (Default: jaxx.compiler.decorators.DefaultCompiledObjectDecorator)", 2 );
                append( sb, "the FQN of the ui to use for error notification.\nIf not given, will use the one defined in validator\n", 3 );
                append( sb, "", 0 );

                append( sb, "defaultErrorUIFQN", 2 );
                append( sb, "the FQN of the ui to use for error notification.\nIf not given, will use the one defined in validator\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding pour la generation des fichiers", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "pour filter les fichiers a ne pas traiter", 3 );
                append( sb, "", 0 );

                append( sb, "extraImportList", 2 );
                append( sb, "list of fqn of class toimport for all generated jaxx files", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "to force generation of java source for any jaxx files with no timestamp checking.\nBy default, never force generation.\n", 3 );
                append( sb, "", 0 );

                append( sb, "generateHelp (Default: false)", 2 );
                append( sb, "flag to activate help generation process.\nBy default, not active.\n", 3 );
                append( sb, "", 0 );

                append( sb, "helpBrokerFQN (Default: jaxx.runtime.swing.help.JAXXHelpBroker)", 2 );
                append( sb, "the FQN of help broker\nBy default, use the JAXX implementation JAXXHelpBroker.\n", 3 );
                append( sb, "", 0 );

                append( sb, "helpIdsStore (Default: target/generated-sources/jaxx/helpIds.properties)", 2 );
                append( sb, "The store of helpIds generated by the goal GenerateMojo and then used by the goal GenerateHelpMojo.", 3 );
                append( sb, "", 0 );

                append( sb, "i18nable (Default: true)", 2 );
                append( sb, "to make compiler i18nable, says add the I18n._() method invocation on I18nHelper.I18N_ATTRIBUTES attributes.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "pour filter les fichiers a traiter", 3 );
                append( sb, "", 0 );

                append( sb, "jaxxContextFQN (Default: jaxx.runtime.context.DefaultJAXXContext)", 2 );
                append( sb, "the name of implementation of JAXXContext to be used on JAXXObject.\nMust not be abstract.\n", 3 );
                append( sb, "", 0 );

                append( sb, "optimize (Default: false)", 2 );
                append( sb, "pour optimizer le code compile ou genere ?", 3 );
                append( sb, "", 0 );

                append( sb, "outJava (Default: ${basedir}/target/generated-sources/java)", 2 );
                append( sb, "Repertoire de destination des fichiers java a generer.", 3 );
                append( sb, "", 0 );

                append( sb, "profile (Default: false)", 2 );
                append( sb, "flag to activate profile mode.\nBy default, not active.\n", 3 );
                append( sb, "", 0 );

                append( sb, "resetAfterCompile (Default: true)", 2 );
                append( sb, "flag to keep compilers after the generate operation (usefull for tests.\nBy default, always reset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/java)", 2 );
                append( sb, "Repertoire sources des fichiers jaxx a generer.", 3 );
                append( sb, "", 0 );

                append( sb, "testPhase (Default: false)", 2 );
                append( sb, "A flag to mark themojo to be used in a test phase. This will permits to add generated sources in test compile roots.", 3 );
                append( sb, "", 0 );

                append( sb, "useUIManagerForIcon (Default: false)", 2 );
                append( sb, "a flag to use UIManager to retreave icons.", 3 );
                append( sb, "", 0 );

                append( sb, "validatorFQN (Default: jaxx.runtime.validator.swing.SwingValidator)", 2 );
                append( sb, "Le compilateur \u00e0 utiliser (par d\u00e9faut celui de Swing)", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "verbose flag", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate-help".equals( goal ) )
        {
            append( sb, "jaxx:generate-help", 0 );
            append( sb, "Mojo to generate javax help stuff for your project. HelpIds should have been discovered by the JaxxMojo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "contentTemplate (Default: /defaultContent.html.vm)", 2 );
                append( sb, "The template used to generate helpset content file. Must be an existing file or a ressource in class-path", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding pour la generation des fichiers", 3 );
                append( sb, "", 0 );

                append( sb, "generateSearch (Default: true)", 2 );
                append( sb, "Flag to generate the search index.", 3 );
                append( sb, "", 0 );

                append( sb, "helpIdsStore (Default: target/generated-sources/jaxx/helpIds.properties)", 2 );
                append( sb, "The store of helpIds generated by the goal GenerateMojo and then used by the goal GenerateHelpMojo.", 3 );
                append( sb, "", 0 );

                append( sb, "helpsetName (Default: ${project.artifactId})", 2 );
                append( sb, "The name of the helpset to generate.", 3 );
                append( sb, "", 0 );

                append( sb, "helpsetTemplate (Default: /defaultHelpSet.hs.vm)", 2 );
                append( sb, "The template used to generate helpset file. Must be an existing file or a ressource in class-path", 3 );
                append( sb, "", 0 );

                append( sb, "indexTemplate (Default: /defaultIndex.xml.vm)", 2 );
                append( sb, "The template used to generate helpset index file. Must be an existing file or a ressource in class-path", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "The locales to generate for help, seprated by comma. The first locale given is the default locale.", 3 );
                append( sb, "", 0 );

                append( sb, "mapTemplate (Default: /defaultMap.jhm.vm)", 2 );
                append( sb, "The template used to generate helpset map file. Must be an existing file or a ressource in class-path", 3 );
                append( sb, "", 0 );

                append( sb, "outHelp (Default: ${project.basedir}/src/main/help)", 2 );
                append( sb, "The directory where to generate help files.", 3 );
                append( sb, "", 0 );

                append( sb, "tocTemplate (Default: /defaultToc.xml.vm)", 2 );
                append( sb, "The template used to generate helpset toc file. Must be an existing file or a ressource in class-path", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "verbose flag", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jaxx:help", 0 );
            append( sb, "Display help information on maven-jaxx-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jaxx:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
