/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TemplateGenerator {
    protected VelocityEngine engine;
    protected final MavenProject mavenProject;
    protected Template velocityTemplate;

    protected TemplateGenerator(MavenProject mavenProject, URL template) throws URISyntaxException {
        String templateName;
        if (mavenProject == null) {
            throw new IllegalArgumentException("mavenProject must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("template must not be null");
        }
        this.mavenProject = mavenProject;
        Properties props = new Properties();
        if (template.toURI().isOpaque()) {
            props = new Properties();
            props.setProperty("resource.loader", "jar");
            props.setProperty("jar.resource.loader.description", "Jar resource loader for default webstart templates");
            props.setProperty("jar.resource.loader.class", "org.apache.velocity.runtime.resource.loader.JarResourceLoader");
            String url = template.toString();
            int i = url.indexOf("!");
            templateName = url.substring(i + 2);
            props.setProperty("jar.resource.loader.path", url.substring(0, i + 2));
        } else {
            templateName = new File(template.getFile()).getName();
            props.setProperty("file.resource.loader.path", template.getFile());
        }
        try {
            this.engine = new VelocityEngine();
            this.engine.init(props);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not initialise Velocity");
            iae.initCause(e);
            throw iae;
        }
        try {
            this.velocityTemplate = this.engine.getTemplate(templateName);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not load the template file from '" + template + "'");
            iae.initCause(e);
            throw iae;
        }
    }

    public void generate(Properties context, File outputFile) throws Exception {
        VelocityContext vcontext = new VelocityContext();
        this.addPropertiesToContext(System.getProperties(), vcontext);
        this.addPropertiesToContext(this.mavenProject.getProperties(), vcontext);
        this.addPropertiesToContext(context, vcontext);
        vcontext.put("project", (Object)this.mavenProject.getModel());
        vcontext.put("outputFile", (Object)outputFile.getName());
        FileWriter writer = new FileWriter(outputFile);
        try {
            this.velocityTemplate.merge((Context)vcontext, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new Exception("Could not generate the template " + this.velocityTemplate.getName() + ": " + e.getMessage(), e);
        }
        finally {
            writer.close();
        }
    }

    protected void addPropertiesToContext(Properties properties, VelocityContext context) {
        for (String string : properties.keySet()) {
            Object value = properties.get(string);
            context.put(string, value);
        }
    }
}

