/* *##%
 * Copyright (C) 2007
 *     JaxxPlugin, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/
package org.nuiton.jaxx;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

import java.io.File;

/**
 * Abract Jaxx Mojo.
 *
 * @author chemit
 *
 * @since 1.3
 */
public abstract class AbstractJaxxMojo extends AbstractMojo {

    /**
     * Dépendance du projet.
     *
     * @parameter default-value="${project}"
     * @required
     * @readonly
     */
    protected MavenProject project;
    /**
     * Repertoire de destination des fichiers java a generer.
     *
     * @parameter expression="${jaxx.outJava}" default-value="${basedir}/target/generated-sources/java"
     */
    protected File outJava;
    /**
     * verbose flag
     *
     * @parameter expression="${jaxx.verbose}" default-value="false"
     *
     * @since 1.3
     */
    protected boolean verbose;
    /**
     * to make compiler i18nable, says add the {@link org.nuiton.i18n.I18n#_(String, Object[])} method
     * invocation on {@link jaxx.compiler.I18nHelper#I18N_ATTRIBUTES} attributes.
     *
     * @parameter expression="${jaxx.i18nable}" default-value="true"
     * @see jaxx.compiler.I18nHelper
     */
    protected boolean i18nable;
    /**
     * The store of helpIds generated by {@link JaxxGeneratorMojo}.
     * <p/>
     *
     * @parameter expression="${jaxx.helpIdStore}" default-value="target/helpIds.properties"
     * @required
     *
     * @since 1.3
     */
    protected File helpIdStore;
    /**
     * The name of the helpset to generate.
     *
     * @parameter expression="${jaxx.helpSetName}" default-value="${project.artifactId}"
     * @required
     *
     * @since 1.3
     */
    protected String helpSetName;
    /**
     * The prefix to add to i18n key for any help i18n key.
     *
     * @parameter expression="${jaxx.helpsetI18nPrefix}" default-value="${jaxx.helpSetName}.help."
     * @required
     *
     * @since 1.3
     */
    protected String helpsetI18nPrefix;
    /**
     * The suffix to add to i18n key for an help Id.
     *
     * @parameter expression="${jaxx.helpsetTitleI18nSuffix}" default-value=".title"
     * @required
     *
     * @since 1.3
     */
    protected String helpsetTitleI18nSuffix;
    /**
     * The suffix to add to i18n key for an toc Id.
     *
     * @parameter expression="${jaxx.helpsetTocI18nSuffix}" default-value=".toc"
     * @required
     *
     * @since 1.3
     */
    protected String helpsetTocI18nSuffix;
    /**
     * The suffix to add to i18n key for an toc Id.
     *
     * @parameter expression="${jaxx.helpsetIndexI18nSuffix}" default-value=".index"
     * @required
     *
     * @since 1.3
     */
    protected String helpsetIndexI18nSuffix;
    protected boolean skip = true;
    protected ClassLoader cl;

    public abstract void init() throws Exception;

    public abstract void doAction() throws Exception;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {

        try {
            init();
        } catch (Exception e) {
            if (e instanceof MojoFailureException) {
                throw (MojoFailureException) e;
            }
            if (e instanceof MojoExecutionException) {
                throw (MojoExecutionException) e;
            }
            throw new MojoExecutionException("error in init : " + e.getMessage(), e);
        }

        if (skip) {
            if (verbose) {
                getLog().info("jaxx - skip!");
            }
            return;
        }

        try {

            doAction();

        } catch (Exception e) {
            //getLog().error(e);
            Throwable e2 = e;
            while (e2.getCause() != null) {
                e2 = e.getCause();
            }
            getLog().error(e2);

            throw new MojoExecutionException(e2.getMessage(), e2);
        } finally {
            System.gc();
        }

    }

}