/*
 * #%L
 * JAXX :: Widgets
 * $Id: KeyStrokeEditor.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.5/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/KeyStrokeEditor.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor;

import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Custom text field to disable default key events
 *
 * @author sletellier <letellier@codelutin.com>
 */
public class KeyStrokeEditor extends JTextField {

    private static final Log log = LogFactory.getLog(KeyStrokeEditor.class);

    protected KeyStroke keyStroke;

    public KeyStrokeEditor() {
        enableEvents(KeyEvent.KEY_EVENT_MASK);
        setFocusTraversalKeysEnabled(false);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == KeyEvent.KEY_PRESSED) {
            int keyCode = e.getKeyCode();
            if (keyCode == KeyEvent.VK_SHIFT ||
                keyCode == KeyEvent.VK_ALT ||
                keyCode == KeyEvent.VK_CONTROL ||
                keyCode == KeyEvent.VK_ALT_GRAPH ||
                keyCode == KeyEvent.VK_META) {

                return;
            }

            setKeyStroke(KeyStroke.getKeyStroke(keyCode, e.getModifiers()));
        }
    }

    public KeyStroke getKeyStroke() {
        return keyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        KeyStroke oldValue = getKeyStroke();
        this.keyStroke = keyStroke;
        firePropertyChange("keyStroke", oldValue, keyStroke);
        fireActionPerformed();
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                setText(getKeyStroke().toString());
            }
        });
    }
}
