package jaxx.runtime.swing.editor.gis;

/*
 * #%L
 * JAXX :: Widgets
 * $Id: MaskFormatterFromConverter.java 2756 2013-11-26 14:10:47Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.1/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/gis/MaskFormatterFromConverter.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.commons.beanutils.Converter;

import javax.swing.text.MaskFormatter;
import java.text.ParseException;

/**
 * Created on 11/25/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.6
 */
public class MaskFormatterFromConverter<O> extends MaskFormatter {

    private static final long serialVersionUID = 1L;

    private final Converter converter;

    private final Class<O> type;

    public static <O> MaskFormatterFromConverter<O> newFormatter(Class<O> type,
                                                                 String pattern,
                                                                 Converter converter) throws ParseException {
        return new MaskFormatterFromConverter<O>(type, pattern, converter);
    }

    protected MaskFormatterFromConverter(Class<O> type,
                                      String pattern,
                                      Converter converter) throws ParseException {
        super(pattern);
        this.type = type;
        this.converter = converter;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        return (String) converter.convert(String.class, value);
    }

    @Override
    public Object stringToValue(String value) throws ParseException {
        return converter.convert(type, value);
    }

    protected Converter getConverter() {
        return converter;
    }

    protected Class<O> getType() {
        return type;
    }
}
