package jaxx.runtime.swing;

/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClockWidget extends JLabel implements ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DELAY = "delay";
    public static final String PROPERTY_PATTERN = "pattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1SPW8TQRAdX2I7dvgIWEQBQpSE1Gd6IwgyskhkQMJIRLhh7dvYl6z3lt05cmkQP4GfAD0NEh0VoqCmoEH8BYQoaBGzd2efAwfkit3T7MybN2/eq69QNBrW9lgUuTqU6I+4u31jZ+dub4/38SY3fe0rDDQkX8EBpwvz3iRuEC5327a8npbXm8FIBZLLqepGG6oGDwU3Q84R4dLRir4x9c7kuRGpUI9RJ6TyUF98/+Y89569dAAiRexmaZTV/1Vlk8y2wfE9hLPU6QmrCyYHREP7ckB8T9pYUzBj7rARfwxPodyGkmKawBDWjz9yjBHXRwphbmO7zXpcXEFYOcLUHFBftymC/v4D3xtwVCquKiEUPS7YIcIZS8m1NN0tiXzAdZZTVgyRa4mwkGUlw0wB2U46BYrSlvdtjHI0XDxCiJbiZkvJVCt0oahDCiMsdf/c4z16Sja49NsGLWD8+nOx9untlzet8dpmqPe53NQp15GcSgeK6Pu29elkZyH6on6bqUYXKoYLsmxsyeUcYp30mchRv0RLW+7eYmZIEMXy53fvFx99nAGnBVURMK/FbP4WVHCoSYVAeJG6vhkzOnEwR+eC5YZQ7bH+/kAHoSQznbrqMWSrPV96pO61iIRYzhFiwqZX+fCj1nm9ORajQOTO/zU9E6T4EEq+FL7ksYtTg+a6dl4ZHnpBZsQ8axbsXVWpWS7E50rutLuB5sm0NmctCu21HlO3fxvHRkp8/Q+QGoH8Asioz+yiBAAA";
    private static final Log log = LogFactory.getLog(ClockWidget.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Integer delay;
    protected String pattern;
    protected Timer timer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ClockWidget $JLabel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_DELAY, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                timer = new Timer((Integer) evt.getNewValue(), ClockWidget.this);
            }
        });
    }
    
    @Override
    public void actionPerformed(ActionEvent evt) {
        update();
    }
    
    /** Adds a feature to the Notify attribute of the Clock object */
    @Override
    public void addNotify() {
        super.addNotify();
        update();
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        timer.stop();
        super.removeNotify();
    }
    
    protected void update() {
        DateFormat format = new SimpleDateFormat(pattern);
        setText(format.format(new Date()));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ClockWidget(String param0, Icon param1, int param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, String param1, Icon param2, int param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(String param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, String param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(Icon param0) {
        super(param0);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, Icon param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget() {
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(String param0) {
        super(param0);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ClockWidget(Icon param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ClockWidget(JAXXContext parentContext, Icon param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Integer getDelay() {
        return delay;
    }

    public String getPattern() {
        return pattern;
    }

    public Timer getTimer() {
        return timer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDelay(Integer delay) {
        Integer oldValue = this.delay;
        this.delay = delay;
        firePropertyChange(PROPERTY_DELAY, oldValue, delay);
    }

    public void setPattern(String pattern) {
        String oldValue = this.pattern;
        this.pattern = pattern;
        firePropertyChange(PROPERTY_PATTERN, oldValue, pattern);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDelay() {
        $objectMap.put("delay", delay = 60000);
    }

    protected void createPattern() {
        $objectMap.put("pattern", pattern = "HH:mm");
    }

    protected void createTimer() {
        $objectMap.put("timer", timer = new Timer(delay,this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 property setters
        setBackground(Color.WHITE);
        setForeground(Color.BLACK);
        timer.setDelay(delay);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JLabel0", $JLabel0);
        createDelay();
        createPattern();
        createTimer();
        // inline creation of $JLabel0
        setName("$JLabel0");
        
        $completeSetup();
    }

}