package jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class AboutPanel extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ABOUT_TEXT = "aboutText";
    public static final String PROPERTY_BACKGROUND_COLOR = "backgroundColor";
    public static final String PROPERTY_BOTTOM_TEXT = "bottomText";
    public static final String PROPERTY_ICON_PATH = "iconPath";
    public static final String PROPERTY_LICENSE_TEXT = "licenseText";
    public static final String PROPERTY_THIRDPARTY_TEXT = "thirdpartyText";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BOTTOM_LABEL_TEXT = "bottomLabel.text";
    public static final String BINDING_BOTTOM_LABEL_VISIBLE = "bottomLabel.visible";
    public static final String BINDING_LICENSE_TEXT_AREA_TEXT = "licenseTextArea.text";
    public static final String BINDING_THIRDPARTY_TEXT_AREA_TEXT = "thirdpartyTextArea.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JEDITOR_PANE0_TEXT = "$JEditorPane0.text";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";
    private static final String BINDING_$TABLE0_BACKGROUND = "$Table0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz2/cRBSeLNkkm22bJlFLS4tI6UpIQL0pvwQkCk0DURttS9SNUNW9MLan2WlnZ8zMuHF6QFy48yfAnQsSN06IA2cOXBD/AkIcuCLejL32OnFcq96DN/ve+75575uZz/n+L9RUEl15hKPIkSHXdEScnc379z91HxFPf0yUJ2mghUTxZ6qBGgPU9tO40ujqoGfg3QTe3RKjQHDCJ9BrPTSv9CEjakiI1ujlPMJTqttP02tREMoxa9pUEeu3//zd+Mb/6rsGQlEA3V2EUVaehcomme6hBvU1WoKVnuAuw3wf2pCU70O/p01si2Gl7uIR+QJ9iWZ7aCbAEsg0erX6yJbD4qNAo9nOHnYZWQUNco2qA1jW2XRFqHcxJywILGYGEEPMfUakRp1SxK24LAM2NdWMaHTWTOKY6Zx4uqxkjnqC72I9NL8Xs3gLG9o9EukjiXlXaC1GBZk2ox7hihSkzughlT5Ipw8Lsgsu9h7vSxFyf0swAXOesQ3jA+3YwES7nR07Kqi3ZGqiRIQ4aopak7U97BbU2qgpeiWr1SJIKa7keaY1duGQv5jjgD10iW8g+eJTVrctwbU9JXlQ35OCsTHotRR0urPziU/hyJjU6lFUljLlr2eiJnoni5nom3nehYkd2ZQEa3QuP0QSN+WrKWox26yTqZfyOzpmecc83j22XdcLZG3HByndjI55fJCdXY8JBWd3OdfxzRAwPF/ZMhfqNn8oQLmXCi5Ikg2OA2xbNwsSb40TEl3KMYJPOZlPZUYyNUBNGUJYowuD49Z2D1KxqV04YmqG0Gb/O7/8+09//rg9drJLsPa5wtIJIwaHCaQIwBqoWXohtrFQU9a9g4O1AWopwsDFrUtfLmisn6ShOVhv0V47A3duYTUEiubsHz//cv7z315AjW00zwT2t7Gpv41aeihBBcH8KPjohu3o1MEcPM+a3oxPpJcajuq6jzVecSn3YUc2IhDicoEQaTdu69d/l/s/3BiLMQXNXTyxPBOk+QDNUM4oJ9bYE88uNPJ2oEjoi8ybi9x6ynzPB8kJ6dnnbtG0M66QPpEm349C87Vn2zZ/fVaRxYTvlTCsVOmD4UPwn5osrYdw768p+hSO+NJ6LOgK1vDqcENNNoqJr1YgntaJ+5/QXBWO2SdUUXiB1qIx4QclDG/UZnAqjNL2Yn/dOwzsOPT5qeYIvCVwIstz85gwrzXUs2S5Xpvh7UoMX5foUI1hWJuhTMlqDGU6vFeb4f3aSlZjKFOyGkOZktUYvBKGDyvcr+WhkPQpXFfMNhnd56Pk36ITKNdrj1WNQdVigPcFvM2pKOtjA1j+B/mJcI0kDgAA";
    private static final Log log = LogFactory.getLog(AboutPanel.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane aboutContent;
    protected String aboutText;
    protected Color backgroundColor;
    protected JLabel bottomLabel;
    protected String bottomText;
    protected JButton close;
    protected AboutPanelHandler handler;
    protected String iconPath;
    protected JScrollPane licenseContent;
    protected String licenseText;
    protected JTextArea licenseTextArea;
    protected JTabbedPane tabs;
    protected JScrollPane thirdpartyContent;
    protected String thirdpartyText;
    protected JTextArea thirdpartyTextArea;
    protected String title;
    protected JPanel topPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JEditorPane $JEditorPane0;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private AboutPanel $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLicenseFile(String filename) {
        handler.setLicenseFile(filename);
    }
    
    public void setThirdpartyFile(String filename) {
        handler.setThirdpartyFile(filename);
    }
    
    public void buildTopPanel() {
        handler.buildTopPanel();
    }
    
    public void init() {
        handler.init();
    }
    
    public void showInDialog(Frame ui, boolean undecorated) {
        handler.showInDialog(ui, undecorated);
    }
    
    void $afterCompleteSetup() {
        handler.$afterCompleteSetup();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AboutPanel() {
        $initialize();
    }

    public AboutPanel(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doHyperlinkUpdate__on__$JEditorPane0(HyperlinkEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        SwingUtil.openLink(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JScrollPane getAboutContent() {
        return aboutContent;
    }

    public String getAboutText() {
        return aboutText;
    }

    public Color getBackgroundColor() {
        return backgroundColor;
    }

    public JLabel getBottomLabel() {
        return bottomLabel;
    }

    public String getBottomText() {
        return bottomText;
    }

    public JButton getClose() {
        return close;
    }

    public AboutPanelHandler getHandler() {
        return handler;
    }

    public String getIconPath() {
        return iconPath;
    }

    public JScrollPane getLicenseContent() {
        return licenseContent;
    }

    public String getLicenseText() {
        return licenseText;
    }

    public JTextArea getLicenseTextArea() {
        return licenseTextArea;
    }

    public JTabbedPane getTabs() {
        return tabs;
    }

    public JScrollPane getThirdpartyContent() {
        return thirdpartyContent;
    }

    public String getThirdpartyText() {
        return thirdpartyText;
    }

    public JTextArea getThirdpartyTextArea() {
        return thirdpartyTextArea;
    }

    public String getTitle() {
        return title;
    }

    public JPanel getTopPanel() {
        return topPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAboutText(String aboutText) {
        String oldValue = this.aboutText;
        this.aboutText = aboutText;
        firePropertyChange(PROPERTY_ABOUT_TEXT, oldValue, aboutText);
    }

    public void setBackgroundColor(Color backgroundColor) {
        Color oldValue = this.backgroundColor;
        this.backgroundColor = backgroundColor;
        firePropertyChange(PROPERTY_BACKGROUND_COLOR, oldValue, backgroundColor);
    }

    public void setBottomText(String bottomText) {
        String oldValue = this.bottomText;
        this.bottomText = bottomText;
        firePropertyChange(PROPERTY_BOTTOM_TEXT, oldValue, bottomText);
    }

    public void setIconPath(String iconPath) {
        String oldValue = this.iconPath;
        this.iconPath = iconPath;
        firePropertyChange(PROPERTY_ICON_PATH, oldValue, iconPath);
    }

    public void setLicenseText(String licenseText) {
        String oldValue = this.licenseText;
        this.licenseText = licenseText;
        firePropertyChange(PROPERTY_LICENSE_TEXT, oldValue, licenseText);
    }

    public void setThirdpartyText(String thirdpartyText) {
        String oldValue = this.thirdpartyText;
        this.thirdpartyText = thirdpartyText;
        firePropertyChange(PROPERTY_THIRDPARTY_TEXT, oldValue, thirdpartyText);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JEditorPane get$JEditorPane0() {
        return $JEditorPane0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAboutContent() {
        if (!allComponentsCreated) {
            return;
        }
        aboutContent.getViewport().add($JEditorPane0);
    }

    protected void addChildrenToLicenseContent() {
        if (!allComponentsCreated) {
            return;
        }
        licenseContent.getViewport().add(licenseTextArea);
    }

    protected void addChildrenToTabs() {
        if (!allComponentsCreated) {
            return;
        }
        tabs.add(aboutContent);
        tabs.add(licenseContent);
        tabs.add(thirdpartyContent);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabs, 0));
        tabs.setTitleAt(0, t("aboutframe.about"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabs, 1));
        tabs.setTitleAt(1, t("aboutframe.license"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabs, 2));
        tabs.setTitleAt(2, t("aboutframe.thirdparty"));
    }

    protected void addChildrenToThirdpartyContent() {
        if (!allComponentsCreated) {
            return;
        }
        thirdpartyContent.getViewport().add(thirdpartyTextArea);
    }

    protected void createAboutContent() {
        $objectMap.put("aboutContent", aboutContent = new JScrollPane());
        
        aboutContent.setName("aboutContent");
    }

    protected void createAboutText() {
        $objectMap.put("aboutText", aboutText = null);
    }

    protected void createBackgroundColor() {
        $objectMap.put("backgroundColor", backgroundColor = null);
    }

    protected void createBottomLabel() {
        $objectMap.put("bottomLabel", bottomLabel = new JLabel());
        
        bottomLabel.setName("bottomLabel");
    }

    protected void createBottomText() {
        $objectMap.put("bottomText", bottomText = null);
    }

    protected void createClose() {
        $objectMap.put("close", close = new JButton());
        
        close.setName("close");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AboutPanelHandler(this));
    }

    protected void createIconPath() {
        $objectMap.put("iconPath", iconPath = null);
    }

    protected void createLicenseContent() {
        $objectMap.put("licenseContent", licenseContent = new JScrollPane());
        
        licenseContent.setName("licenseContent");
    }

    protected void createLicenseText() {
        $objectMap.put("licenseText", licenseText = null);
    }

    protected void createLicenseTextArea() {
        $objectMap.put("licenseTextArea", licenseTextArea = new JTextArea());
        
        licenseTextArea.setName("licenseTextArea");
        licenseTextArea.setColumns(15);
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setWrapStyleWord(true);
        licenseTextArea.setEditable(false);
        if (licenseTextArea.getFont() != null) {
            licenseTextArea.setFont(licenseTextArea.getFont().deriveFont((float) 11));
        }
    }

    protected void createTabs() {
        $objectMap.put("tabs", tabs = new JTabbedPane());
        
        tabs.setName("tabs");
    }

    protected void createThirdpartyContent() {
        $objectMap.put("thirdpartyContent", thirdpartyContent = new JScrollPane());
        
        thirdpartyContent.setName("thirdpartyContent");
    }

    protected void createThirdpartyText() {
        $objectMap.put("thirdpartyText", thirdpartyText = null);
    }

    protected void createThirdpartyTextArea() {
        $objectMap.put("thirdpartyTextArea", thirdpartyTextArea = new JTextArea());
        
        thirdpartyTextArea.setName("thirdpartyTextArea");
        thirdpartyTextArea.setColumns(15);
        thirdpartyTextArea.setLineWrap(true);
        thirdpartyTextArea.setWrapStyleWord(true);
        thirdpartyTextArea.setEditable(false);
        if (thirdpartyTextArea.getFont() != null) {
            thirdpartyTextArea.setFont(thirdpartyTextArea.getFont().deriveFont((float) 11));
        }
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new JPanel());
        
        topPanel.setName("topPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add(tabs, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add($JPanel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel0, BorderLayout.CENTER);
        addChildrenToTabs();
        addChildrenToAboutContent();
        addChildrenToLicenseContent();
        addChildrenToThirdpartyContent();
        // inline complete setup of $JPanel1
        $JPanel1.add(bottomLabel, BorderLayout.CENTER);
        $JPanel1.add(close, BorderLayout.EAST);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        $JPanel0.setBackground(Color.WHITE);
        aboutContent.setBorder(null);
        $JEditorPane0.setBorder(null);
        licenseContent.setBorder(null);
        licenseTextArea.setBorder(null);
        thirdpartyContent.setBorder(null);
        thirdpartyTextArea.setBorder(null);
        bottomLabel.setHorizontalAlignment(SwingConstants.CENTER);
        close.setAction(handler.closeAction);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createTitle();
        createIconPath();
        createAboutText();
        createBottomText();
        createLicenseText();
        createThirdpartyText();
        createBackgroundColor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont((float) 12));
        }
        createTopPanel();
        createTabs();
        createAboutContent();
        // inline creation of $JEditorPane0
        $objectMap.put("$JEditorPane0", $JEditorPane0 = new JEditorPane());
        
        $JEditorPane0.setName("$JEditorPane0");
        $JEditorPane0.setContentType("text/html");
        $JEditorPane0.setEditable(false);
        $JEditorPane0.addHyperlinkListener(JAXXUtil.getEventListener(HyperlinkListener.class, "hyperlinkUpdate", this, "doHyperlinkUpdate__on__$JEditorPane0"));
        createLicenseContent();
        createLicenseTextArea();
        createThirdpartyContent();
        createThirdpartyTextArea();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createBottomLabel();
        createClose();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("aboutframe.about"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("aboutframe.license"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(t("aboutframe.thirdparty"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$TABLE0_BACKGROUND, true ,"backgroundColor") {
        
            @Override
            public void processDataBinding() {
                setBackground(getBackgroundColor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(t(SwingUtil.getStringValue(getTitle())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true ,"title") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setVisible(getTitle() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JEDITOR_PANE0_TEXT, true ,"aboutText") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText($JEditorPane0, SwingUtil.getStringValue(getAboutText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LICENSE_TEXT_AREA_TEXT, true ,"licenseText") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(licenseTextArea, SwingUtil.getStringValue(getLicenseText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THIRDPARTY_TEXT_AREA_TEXT, true ,"thirdpartyText") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(thirdpartyTextArea, SwingUtil.getStringValue(getThirdpartyText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOTTOM_LABEL_TEXT, true ,"bottomText") {
        
            @Override
            public void processDataBinding() {
                bottomLabel.setText(t(SwingUtil.getStringValue(getBottomText())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOTTOM_LABEL_VISIBLE, true ,"bottomText") {
        
            @Override
            public void processDataBinding() {
                bottomLabel.setVisible(getBottomText() != null);
            }
        });
    }

}