package jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.plaf.basic.ExtendedBasicDatePickerUI;

public class JAXXDatePicker extends JXDatePicker implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PATTERN_LAYOUT = "patternLayout";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdH7GDHfIBFlEQQQof9ZkSyQiCEywcGYiwIlm4Ye1b7HXOu8vuHL40iJ/AT4CeBomOClFQU9Ag/gJCFLSIuTvH54RDcIVP3n0z8+a9d6+/Qd4auDhkYeiaQKIYcXfnVrt9vzvkPdzmtmeERmUgeXIOOB1Y8KbnFuFypxmVVybllS010kpyOVNdbULJ4oHP7YBzRLhwtKJnbaU1va6GOjCHXaeksrq+/PHdeeE9f+UAhJrYzdEqG/+qSjeZa4IjPIQzNOkpq/hM9omGEbJPfBejsy2fWXuPjfgTeAbzTShoZqgZwqX/XznuEdeHGmHpyk57myHfFb19bq7iMentmKbHBqQgrePyAsKyHajxrtKBrgWISiKcjli6EXO3ppTPmUzRi5ohciOb7EARHFZSbLJlCi3xELn0uLfXQLimTN8dksX7qHTCKHS1zx67XWZFz709wdaifynNvQb1M3D+yD7krJs6m0qf60DeBHSMsNb5MwwP6CqJwdqxGEQN49tfq+XP776+rR96n6PZZzOhM9ElT7RRmhsU0ejlxPgAhV+5y3S1A0XLfcp9nOv1DGKtyTWRo3mJ+lG5e4fZAbXIz395/2H10acT4NSh5Cvm1VmEb0ARB4ZUUL4X6pubMaNT45P0uxJxy/J26brHkG10hfTIghshqbGeocaUUrf48We59WZzVpFzf4WnquQfQkFIX0gefw+TqGfmf0FbHngqjXRWyHPRu6y1/g2Nt0yaXQQAAA==";
    private static final Log log = LogFactory.getLog(JAXXDatePicker.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ExtendedBasicDatePickerUI extendedUI;
    protected String patternLayout;
    protected Boolean showPopupButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JAXXDatePicker $JXDatePicker0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
            setUI(extendedUI);
    
            addPropertyChangeListener(PROPERTY_SHOW_POPUP_BUTTON, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    extendedUI.setShowPopupButton((Boolean) evt.getNewValue());
                }
            });
    
            addPropertyChangeListener(PROPERTY_PATTERN_LAYOUT, new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    setFormats(new SimpleDateFormat((String) evt.getNewValue()));
                }
            });
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXDatePicker(Date param0) {
        super(param0);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Date param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker(Locale param0) {
        super(param0);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Locale param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker(Date param0, Locale param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext, Date param1, Locale param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public JAXXDatePicker() {
        $initialize();
    }

    public JAXXDatePicker(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ExtendedBasicDatePickerUI getExtendedUI() {
        return extendedUI;
    }

    public String getPatternLayout() {
        return patternLayout;
    }

    public Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPatternLayout(String patternLayout) {
        String oldValue = this.patternLayout;
        this.patternLayout = patternLayout;
        firePropertyChange(PROPERTY_PATTERN_LAYOUT, oldValue, patternLayout);
    }

    public void setShowPopupButton(Boolean showPopupButton) {
        Boolean oldValue = this.showPopupButton;
        this.showPopupButton = showPopupButton;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, showPopupButton);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createExtendedUI() {
        $objectMap.put("extendedUI", extendedUI = new ExtendedBasicDatePickerUI());
    }

    protected void createPatternLayout() {
        $objectMap.put("patternLayout", patternLayout = "dd/MM/yyyy");
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = Boolean.TRUE);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 1 property setters
        extendedUI.setShowPopupButton(showPopupButton);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JXDatePicker0", $JXDatePicker0);
        createShowPopupButton();
        createPatternLayout();
        createExtendedUI();
        // inline creation of $JXDatePicker0
        setName("$JXDatePicker0");
        
        $completeSetup();
    }

}