/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.editor.cell;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import org.nuiton.jaxx.widgets.editor.number.NumberEditor2;
import org.nuiton.jaxx.widgets.editor.number.NumberEditor2Model;

public class NumberCellEditor<E extends Number>
extends AbstractCellEditor
implements TableCellEditor,
FocusListener,
AncestorListener {
    private static final long serialVersionUID = 1L;
    protected final NumberEditor2 numberEditor = new NumberEditor2();

    public NumberCellEditor(Class<E> type, boolean useSign) {
        this.numberEditor.getTextField().setHorizontalAlignment(4);
        this.numberEditor.getTextField().setBorder(null);
        this.numberEditor.getTextField().addFocusListener(this);
        this.numberEditor.getTextField().addAncestorListener(this);
        this.numberEditor.setNumberType(type);
        this.numberEditor.setUseSign(useSign);
        this.numberEditor.init();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Number number = (Number)value;
        this.numberEditor.setNumberValue(number);
        return this.numberEditor;
    }

    public NumberEditor2 getNumberEditor() {
        return this.numberEditor;
    }

    public E getCellEditorValue() {
        NumberEditor2Model model = this.numberEditor.getModel();
        return (E)model.getNumberValue();
    }

    @Override
    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NumberCellEditor.this.numberEditor.getTextField().requestFocus();
                NumberCellEditor.this.numberEditor.getTextField().selectAll();
            }
        });
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NumberCellEditor.this.numberEditor.getTextField().requestFocus();
                NumberCellEditor.this.numberEditor.getTextField().selectAll();
            }
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public boolean stopCellEditing() {
        boolean result = super.stopCellEditing();
        if (result) {
            this.numberEditor.setNumberValue(null);
            this.numberEditor.applyDataBinding("textField.text");
        }
        return result;
    }
}

