package org.nuiton.jaxx.widgets;

/*
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Predicate;
import jaxx.runtime.swing.JAXXRuntimeException;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;

/**
 * A property change listener to mutate to a bean after a predicate is applied.
 *
 * Created on 11/23/14.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.17
 */
public class MutateOnConditionalPropertyChangeListener<M extends ModelToBean> implements PropertyChangeListener {

    private final M model;

    private final Method mutator;

    private final Predicate<M> canMutatePredicate;

    public MutateOnConditionalPropertyChangeListener(M model, Method mutator, Predicate<M> canMutatePredicate) {
        this.model = model;
        this.mutator = mutator;
        this.canMutatePredicate = canMutatePredicate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {

        if (canMutatePredicate.apply(model)) {

            Object newValue = evt.getNewValue();

            try {

                mutator.invoke(model.getBean(), newValue);

            } catch (Exception e) {
                throw new JAXXRuntimeException(e);
            }

        }

    }
}
