package jaxx.runtime.swing.editor;

/*
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.jdesktop.beans.AbstractSerializableBean;

import java.util.regex.Pattern;

/**
 * Created on 2/11/14.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8.1
 */
public class NumberEditor2Model extends AbstractSerializableBean {

    public static final String PROPERTY_BEAN = "bean";

    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";

    public static final String PROPERTY_NUMBER_TYPE = "numberType";

    public static final String PROPERTY_NUMBER_PATTERN = "numberPattern";

    public static final String PROPERTY_USE_SIGN = "useSign";

    public static final String PROPERTY_SHOW_RESET = "showReset";

    public static final String PROPERTY_SHOW_POPUP = "showPopup";

    public static final String PROPERTY_AUTO_POPUP = "autoPopup";

    public static final String PROPERTY_MODEL = "model";

    public static final String PROPERTY_MODEL_TEXT = "modelText";

    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";

    public static final String PROPERTY_SELECT_ALL_TEXT_ON_ERROR = "selectAllTextOnError";

    public static final String PROPERTY_SHOW_RESET_TIP = "showResetTip";

    private static final long serialVersionUID = 1L;

    protected Object bean;

    protected String beanProperty;

    protected Class<? extends Number> numberType;

    protected Pattern numberPattern;

    protected boolean useSign;

    protected boolean showReset;

    protected boolean showPopup;

    protected boolean autoPopup;

    protected boolean selectAllTextOnError;

    protected boolean popupVisible;

    private String showResetTip;

    public Object getBean() {
        return bean;
    }

    public String getBeanProperty() {
        return beanProperty;
    }

    public Class<? extends Number> getNumberType() {
        return numberType;
    }

    public Pattern getNumberPattern() {
        return numberPattern;
    }

    public boolean isUseSign() {
        return useSign;
    }

    public boolean isShowReset() {
        return showReset;
    }

    public boolean isShowPopup() {
        return showPopup;
    }

    public boolean isAutoPopup() {
        return autoPopup;
    }

    public boolean isSelectAllTextOnError() {
        return selectAllTextOnError;
    }

    public boolean isPopupVisible() {
        return popupVisible;
    }

    public String getShowResetTip() {
        return showResetTip;
    }

    public void setBean(Object bean) {
        Object oldValue = getBean();
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        Object oldValue = getBeanProperty();
        this.beanProperty = beanProperty;
        firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setNumberType(Class<? extends Number> numberType) {
        Object oldValue = getNumberType();
        this.numberType = numberType;
        firePropertyChange(PROPERTY_NUMBER_TYPE, oldValue, numberType);
    }

    public void setNumberPattern(Pattern numberPattern) {
        Object oldValue = getNumberPattern();
        this.numberPattern = numberPattern;
        firePropertyChange(PROPERTY_NUMBER_PATTERN, oldValue, numberPattern);
    }

    public void setUseSign(boolean useSign) {
        Object oldValue = isUseSign();
        this.useSign = useSign;
        firePropertyChange(PROPERTY_USE_SIGN, oldValue, useSign);
    }

    public void setShowReset(boolean showReset) {
        Object oldValue = isShowReset();
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowPopup(boolean showPopup) {
        Object oldValue = isShowPopup();
        this.showPopup = showPopup;
        firePropertyChange(PROPERTY_SHOW_POPUP, oldValue, showPopup);
    }

    public void setAutoPopup(boolean autoPopup) {
        Object oldValue = isAutoPopup();
        this.autoPopup = autoPopup;
        firePropertyChange(PROPERTY_AUTO_POPUP, oldValue, autoPopup);
    }

    public void setSelectAllTextOnError(boolean selectAllTextOnError) {
        Object oldValue = isSelectAllTextOnError();
        this.selectAllTextOnError = selectAllTextOnError;
        firePropertyChange(PROPERTY_SELECT_ALL_TEXT_ON_ERROR, oldValue, selectAllTextOnError);
    }

    public void setPopupVisible(boolean popupVisible) {
        Object oldValue = isPopupVisible();
        this.popupVisible = popupVisible;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, popupVisible);
    }

    public void setShowResetTip(String showResetTip) {
        Object oldValue = getShowResetTip();
        this.showResetTip = showResetTip;
        firePropertyChange(PROPERTY_SHOW_RESET_TIP, oldValue, showResetTip);
    }
}
