/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis;

import java.util.regex.Pattern;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.gis.CoordinateHelper;

public class DmdCoordinate
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    public static final String COORDINATE_STRING_PATTERN = "%s%s\u00b0%s.%s'";
    public static final Pattern COORDINATE_PATTERN = Pattern.compile("(.*)\u00b0(.*)\\.(.*)'");
    public static final String PROPERTY_SIGN = "sign";
    public static final String PROPERTY_DEGREE = "degree";
    public static final String PROPERTY_MINUTE = "minute";
    public static final String PROPERTY_DECIMAL = "decimal";
    protected boolean sign;
    protected Integer degree;
    protected Integer minute;
    protected Integer decimal;

    public static DmdCoordinate empty() {
        return new DmdCoordinate();
    }

    public static DmdCoordinate valueOf(DmdCoordinate decimal) {
        DmdCoordinate r = DmdCoordinate.empty();
        if (decimal != null) {
            r.setSign(decimal.isSign());
            r.setDegree(decimal.getDegree());
            r.setMinute(decimal.getMinute());
            r.setDecimal(decimal.getDecimal());
        }
        return r;
    }

    public static DmdCoordinate valueOf(Float decimal) {
        DmdCoordinate r = new DmdCoordinate();
        r.fromDecimal(decimal);
        return r;
    }

    public static DmdCoordinate valueOf(boolean sign, Integer d, Integer m, Integer dc) {
        DmdCoordinate r = new DmdCoordinate();
        r.setSign(sign);
        r.setDegree(d);
        r.setMinute(m);
        r.setDecimal(dc);
        return r;
    }

    public boolean isSign() {
        return this.sign;
    }

    public Integer getDegree() {
        return this.degree;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public Integer getDecimal() {
        return this.decimal;
    }

    public void setSign(boolean sign) {
        Boolean oldValue = this.isSign();
        this.sign = sign;
        this.firePropertyChange(PROPERTY_SIGN, oldValue, sign);
    }

    public void setDegree(Integer degree) {
        Integer oldValue = this.getDegree();
        this.degree = degree;
        this.firePropertyChange(PROPERTY_DEGREE, oldValue, degree);
    }

    public void setMinute(Integer minute) {
        Integer oldValue = this.getMinute();
        this.minute = minute;
        this.firePropertyChange(PROPERTY_MINUTE, oldValue, minute);
    }

    public void setDecimal(Integer decimal) {
        Integer oldValue = this.getDecimal();
        this.decimal = decimal;
        this.firePropertyChange(PROPERTY_DECIMAL, oldValue, decimal);
    }

    public boolean isNull() {
        return this.degree == null && this.minute == null && this.decimal == null;
    }

    public boolean isDegreeNull() {
        return this.degree == null || this.degree == 0;
    }

    public boolean isMinuteNull() {
        return this.minute == null || this.minute == 0;
    }

    public boolean isDecimalNull() {
        return this.decimal == null || this.decimal == 0;
    }

    public void fromDecimal(Float decimalValue) {
        Integer d = null;
        Integer m = null;
        Integer dc = null;
        boolean si = false;
        if (decimalValue != null) {
            si = decimalValue.floatValue() < 0.0f;
            float absDecimal = Math.abs(decimalValue.floatValue());
            int rest = Math.round(6000.0f * (absDecimal - (float)(d = Integer.valueOf((int)(Math.round((double)absDecimal + 0.5) - 1L))).intValue()));
            if (rest > 0) {
                m = rest / 100;
                dc = rest - m * 100;
            }
        }
        this.degree = d;
        this.minute = m;
        this.decimal = dc;
        this.sign = si;
        if (this.decimal != null) {
            this.removeTrailingZero();
        }
    }

    public Float toDecimal() {
        if (this.isNull()) {
            return null;
        }
        Integer d = this.getNotNullDegree();
        Integer m = this.getNotNullMinute();
        Integer dc = this.getNotNullDecimal();
        Float result = Float.valueOf(d.intValue());
        result = Float.valueOf(result.floatValue() + ((float)m.intValue() + (float)dc.intValue() / 100.0f) / 60.0f);
        if (this.sign) {
            result = Float.valueOf(result.floatValue() * -1.0f);
        }
        result = CoordinateHelper.roundToFourDecimals(result);
        return result;
    }

    public void addTrailingZero() {
        if (this.degree == null) {
            this.degree = 0;
        }
        if (this.minute == null) {
            this.minute = 0;
        }
        if (this.decimal == null) {
            this.decimal = 0;
        }
    }

    public void removeTrailingZero() {
        if (this.degree != null && this.degree == 0) {
            this.degree = null;
        }
        if (this.minute != null && this.minute == 0) {
            this.minute = null;
        }
        if (this.decimal != null && this.decimal == 0) {
            this.decimal = null;
        }
    }

    public Integer getSignedDegree() {
        Integer result = null;
        if (!this.isDegreeNull()) {
            result = this.degree;
            if (this.isSign()) {
                result = result * -1;
            }
        }
        return result;
    }

    public int getNotNullDegree() {
        return this.isDegreeNull() ? 0 : this.degree;
    }

    public int getNotNullMinute() {
        return this.isMinuteNull() ? 0 : this.minute;
    }

    public int getNotNullDecimal() {
        return this.isDecimalNull() ? 0 : this.decimal;
    }

    public boolean isLatitudeDegreeValid() {
        return this.isDegreeValid(false);
    }

    public boolean isLongitudeDegreeValid() {
        return this.isDegreeValid(true);
    }

    public boolean isMinuteValid() {
        boolean result = true;
        if (!this.isMinuteNull()) {
            result = this.minute == 60 ? this.isDecimalNull() : 0 <= this.minute && this.minute < 60;
        }
        return result;
    }

    public boolean isDecimalValid() {
        return this.isDecimalNull() || 0 <= this.decimal && this.decimal < 100;
    }

    public String toString() {
        return "DmdCoordinateComponent{sign=" + this.sign + ", degree=" + this.degree + ", minute=" + this.minute + ", decimal=" + this.decimal + '}';
    }

    public void reset() {
        this.degree = null;
        this.minute = null;
        this.degree = null;
    }

    protected boolean isDegreeValid(boolean longitude) {
        boolean result = true;
        if (!this.isDegreeNull()) {
            int bound;
            int n = bound = longitude ? 180 : 90;
            result = bound == this.degree ? this.isMinuteNull() && this.isDecimalNull() : 0 <= this.degree && this.degree < bound;
        }
        return result;
    }
}

