package org.nuiton.jaxx.widgets.gis.absolute;

/*
 * #%L
 * JAXX :: Widgets Gis
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import static org.nuiton.i18n.I18n.t;

public class CoordinatesEditor extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DD_FORMAT_SELECTED = "ddFormat.selected";
    public static final String BINDING_DMD_FORMAT_SELECTED = "dmdFormat.selected";
    public static final String BINDING_DMS_FORMAT_SELECTED = "dmsFormat.selected";
    public static final String BINDING_LATITUDE_DD_ENABLED = "latitudeDd.enabled";
    public static final String BINDING_LATITUDE_DD_SHOW_RESET = "latitudeDd.showReset";
    public static final String BINDING_LATITUDE_DD_VALUE = "latitudeDd.value";
    public static final String BINDING_LATITUDE_DMD_ENABLED = "latitudeDmd.enabled";
    public static final String BINDING_LATITUDE_DMD_SHOW_RESET = "latitudeDmd.showReset";
    public static final String BINDING_LATITUDE_DMD_VALUE = "latitudeDmd.value";
    public static final String BINDING_LATITUDE_DMS_ENABLED = "latitudeDms.enabled";
    public static final String BINDING_LATITUDE_DMS_SHOW_RESET = "latitudeDms.showReset";
    public static final String BINDING_LATITUDE_DMS_VALUE = "latitudeDms.value";
    public static final String BINDING_LATITUDE_LAYOUT_SELECTED = "latitudeLayout.selected";
    public static final String BINDING_LONGITUDE_DD_ENABLED = "longitudeDd.enabled";
    public static final String BINDING_LONGITUDE_DD_SHOW_RESET = "longitudeDd.showReset";
    public static final String BINDING_LONGITUDE_DD_VALUE = "longitudeDd.value";
    public static final String BINDING_LONGITUDE_DMD_ENABLED = "longitudeDmd.enabled";
    public static final String BINDING_LONGITUDE_DMD_SHOW_RESET = "longitudeDmd.showReset";
    public static final String BINDING_LONGITUDE_DMD_VALUE = "longitudeDmd.value";
    public static final String BINDING_LONGITUDE_DMS_ENABLED = "longitudeDms.enabled";
    public static final String BINDING_LONGITUDE_DMS_SHOW_RESET = "longitudeDms.showReset";
    public static final String BINDING_LONGITUDE_DMS_VALUE = "longitudeDms.value";
    public static final String BINDING_LONGITUDE_LAYOUT_SELECTED = "longitudeLayout.selected";
    public static final String BINDING_MODEL_FORMAT = "model.format";
    public static final String BINDING_MODEL_QUADRANT = "model.quadrant";
    public static final String BINDING_QUADRANT1_ENABLED = "quadrant1.enabled";
    public static final String BINDING_QUADRANT1_SELECTED = "quadrant1.selected";
    public static final String BINDING_QUADRANT2_ENABLED = "quadrant2.enabled";
    public static final String BINDING_QUADRANT2_SELECTED = "quadrant2.selected";
    public static final String BINDING_QUADRANT3_ENABLED = "quadrant3.enabled";
    public static final String BINDING_QUADRANT3_SELECTED = "quadrant3.selected";
    public static final String BINDING_QUADRANT4_ENABLED = "quadrant4.enabled";
    public static final String BINDING_QUADRANT4_SELECTED = "quadrant4.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVYzW8bRRQfmzhfbj5KaUmapkrTi0OrDXaiHgj9StKUVklLmwhF5NKxZ+JstF/dHTeuVkX8AyD+BLhzQeLGCXHgzIEL4l9AiANXxJvdnZ3d9a7Xjuo2Ulbjmff1e/PmvTfz/V+o5NjoyjFutxW7ZTBVp8rDu/v7j+vHtME2qdOwVYuZNvL/CkVUPEBlEs47DF092ObsywH78oapW6ZBjQj32jYad9hLjTpHlDKG5uMcDcdZ3g2X19pWyxZSQ6PSpH77z9/Fb8iX3xURaltg3TxAWcjjkkiGtlFRJQy9C5pe4GUNG00ww1aNJtg7wec2NOw4j7BOn6Mv0Mg2GrawDcIYWuwdsifD429bDM00TNMmqoEZvUdUoNszrU+xQTWGbph2UzFaMGkoHogTlTQpc5Sm6ii47phai3FEgt/xBViWJ32YoZJuEi5o7XSCdji3lDahYaayFqE7vtT1nqTeDQYbCZgJ4ZOaaTSldD57Vq6OvcCaSjCwMXQttp/hguKcwD4pu/z7mZiMyg+M38YvzRZsWDzCfeYNbBN/vXavzSTzVGicv8qnZyOyn7cwsbHBfGQQPzxU2oHQh95uctIxiUdwrDI0GyPeM5tNja6DhabBiS8xNEINXNco6WCu8okreVQrPVHVulFNyxh1gticSXHfHmeKA52Qbq9ztrhnvElOeb1zn3xf8tnLcYpxQbEJJ/V2XzG4SZJRyGXWOgGXQx065LM7/SnRnf61kP619IplMhK8gburcY/K8M50ejkk2SR86gb/rHcqOyPpdG/uox4IPYm3MgjLh6atYxYeosuJk0R0Z8uj8GIyElxPMVFNeZB2oizEZ+ETT+KLoyR7bVwclvX7kPBTDgCvk77G+7bZsmSGGPVBrN/nv/dh3kZzMX4oeIoseLIiFQ5QyW7BNKA76KyRT2HJr44zierIBXqr/1049/tPf/64JUriHOg+n0oaqehQqizbtKjNVK56yq+HLaZqyzvYWjtAYw7VoB3wyv2lFMN2g2UwDvSd5ewKZ1c+wc4RiCiN/PHzLxee/fYOKm7BiTYx2cKc/gEaY0c2eMHUSNu6fcez6MzJKHyn4b/I0FCdwg6gEderba9gO4H45Cl1eBsx588qqrMrJv39qCy9aoOXLqV4KTS1Pvbrv+d2f7gjPFUAy2czyaW3Sp+jYdXQVIN67UPQGaS2C2XLoS1iyg4grSdA0BVczE5ZQVQ9877kNbuIyzz2sPORxk2Z65LY3qIt/fqlIFMLlCVXde75P9JVWVYiE3WBOHwY5J9ltyKN8rPIkjj4CqRyP3QogfakRUEv5AWRURiquJUHBqNNai/JNJPG1WmtaPSs/O0Y1XgN2OJNypQr9Hi5FawZYrQNlrznxXzD1HWoRIImTeuEWPQKS572IdDuBFgYWnWPsEE0asPmPwnECKQVPyoAu1ipLF1fWF2SJp5PMxF6qXJdZt9Evi694P6DXsY16MlC4OrKaro/ZX82aFTVPFTVU6Cq5qCqDhrVSh6qlVOgWslBtTJoVLU8VLVToKrloKrloSrEUF11/Qur4il7fCiR+AmpspSuL3E/6i+VTLvxrj0jlwii1FwSuyj0gHlYCy5yUrlvend4olZ0l1+CBjWsU3twfUcfuqyyGIARKV6BlkUFXDanCtEpTLUWvUjxS9+UG7s3v5KB8H58hW/SJvHqwmTQfb3cpE2bN4TQlorhlFxrqDrWeENLgnEa9Mh9KQ/28EBhh6B2acM0iN+7i7HwyUyKT3Qn3SmcX4zDxR3VgP7AX/THaU6JXvDerle6As+IBn6D6QaciHFnrIx7rJnBEr2SvpnEk3xb6S/znHUTd9eMDB1SpSeH2A25n+QT0d8l+yQv2P2nn2p+xAkVyZCbduNPa/GYiy0NKANFHw/6P2yvF3pPSWg2zS8DyEKx15K37Znu4N94Joo9EPVwYCKp6AO3I/cs3Ly5kLybKYTIbDGb9OOhoEn2dOFbjnTZeTdddpmZpgZbteepmM9UwXcnzQfhY1R/+K/1il93pAMuZlnHX0BzPXAhxQOe9LgLLmcryfKBfOAblBNIL07oJQxSndAZB9lOyAwE+WTZT3Ga/JhghhfqqgGKmrc6BBf4dz5XIkwXvuKfr9MlPAIJ/wOeQtyxNxwAAA==";
    private static final Log log = LogFactory.getLog(CoordinatesEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CoordinatesEditor coordinateEditorTopPanel = this;
    protected Table coordinatesPanel;
    protected JRadioButton ddFormat;
    protected JRadioButton dmdFormat;
    protected JRadioButton dmsFormat;
    protected JAXXButtonGroup formatBG;
    protected JPanel formatPanel;
    protected final CoordinatesEditorHandler handler = new CoordinatesEditorHandler();
    protected AbsoluteDdCoordinateEditor latitudeDd;
    protected AbsoluteDmdCoordinateEditor latitudeDmd;
    protected AbsoluteDmsCoordinateEditor latitudeDms;
    @ValidatorField( validatorId = "validator",  propertyName = "latitude",  editorName = "latitudeEditor")
    protected JPanel latitudeEditor;
    protected JLabel latitudeLabel;
    protected CardLayout2Ext latitudeLayout;
    protected AbsoluteCoordinateEditorModel latitudeModel;
    protected AbsoluteDdCoordinateEditor longitudeDd;
    protected AbsoluteDmdCoordinateEditor longitudeDmd;
    protected AbsoluteDmsCoordinateEditor longitudeDms;
    @ValidatorField( validatorId = "validator",  propertyName = "longitude",  editorName = "longitudeEditor")
    protected JPanel longitudeEditor;
    protected JLabel longitudeLabel;
    protected CardLayout2Ext longitudeLayout;
    protected AbsoluteCoordinateEditorModel longitudeModel;
    protected CoordinatesEditorModel model;
    protected JToggleButton quadrant1;
    protected JToggleButton quadrant2;
    protected JToggleButton quadrant3;
    protected JToggleButton quadrant4;
    protected JAXXButtonGroup quadrantBG;
    @ValidatorField( validatorId = "validator",  propertyName = "quadrant",  editorName = "quadrantEditor")
    protected JPanel quadrantEditor;
    @Validator( validatorId = "validator")
    protected SwingValidator<CoordinatesEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setPropertyQuadrant(String property) { model.setPropertyQuadrant(property); }
    public void setPropertyLatitude(String property) { model.setPropertyLatitude(property); }
    public void setPropertyLongitude(String property) { model.setPropertyLongitude(property); }
    public void setQuadrant(Integer quadrant) { model.setQuadrant(quadrant); }
    public void setLatitude(Float latitude) { model.setLatitude(latitude); }
    public void setLongitude(Float longitude) { model.setLongitude(longitude); }
    public void setFormat(CoordinateFormat format) { model.setFormat(format); }
    public void setShowResetButton(boolean showResetButton) { model.setShowResetButton(showResetButton); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditor() {
        $initialize();
    }

    public CoordinatesEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getCoordinatesPanel() {
        return coordinatesPanel;
    }

    public JRadioButton getDdFormat() {
        return ddFormat;
    }

    public JRadioButton getDmdFormat() {
        return dmdFormat;
    }

    public JRadioButton getDmsFormat() {
        return dmsFormat;
    }

    public JAXXButtonGroup getFormatBG() {
        return formatBG;
    }

    public JPanel getFormatPanel() {
        return formatPanel;
    }

    public CoordinatesEditorHandler getHandler() {
        return handler;
    }

    public AbsoluteDdCoordinateEditor getLatitudeDd() {
        return latitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLatitudeDmd() {
        return latitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLatitudeDms() {
        return latitudeDms;
    }

    public JPanel getLatitudeEditor() {
        return latitudeEditor;
    }

    public JLabel getLatitudeLabel() {
        return latitudeLabel;
    }

    public CardLayout2Ext getLatitudeLayout() {
        return latitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLatitudeModel() {
        return latitudeModel;
    }

    public AbsoluteDdCoordinateEditor getLongitudeDd() {
        return longitudeDd;
    }

    public AbsoluteDmdCoordinateEditor getLongitudeDmd() {
        return longitudeDmd;
    }

    public AbsoluteDmsCoordinateEditor getLongitudeDms() {
        return longitudeDms;
    }

    public JPanel getLongitudeEditor() {
        return longitudeEditor;
    }

    public JLabel getLongitudeLabel() {
        return longitudeLabel;
    }

    public CardLayout2Ext getLongitudeLayout() {
        return longitudeLayout;
    }

    public AbsoluteCoordinateEditorModel getLongitudeModel() {
        return longitudeModel;
    }

    public CoordinatesEditorModel getModel() {
        return model;
    }

    public JToggleButton getQuadrant1() {
        return quadrant1;
    }

    public JToggleButton getQuadrant2() {
        return quadrant2;
    }

    public JToggleButton getQuadrant3() {
        return quadrant3;
    }

    public JToggleButton getQuadrant4() {
        return quadrant4;
    }

    public JAXXButtonGroup getQuadrantBG() {
        return quadrantBG;
    }

    public JPanel getQuadrantEditor() {
        return quadrantEditor;
    }

    public SwingValidator<CoordinatesEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCoordinateEditorTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(SwingUtil.boxComponentWithJxLayer(quadrantEditor), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        add(coordinatesPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(formatPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToCoordinatesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        coordinatesPanel.add(latitudeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(SwingUtil.boxComponentWithJxLayer(latitudeEditor), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(longitudeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordinatesPanel.add(SwingUtil.boxComponentWithJxLayer(longitudeEditor), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToDdFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; ddFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(ddFormat); }
    }

    protected void addChildrenToDmdFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; dmdFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmdFormat); }
    }

    protected void addChildrenToDmsFormat() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = formatBG; dmsFormat.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(dmsFormat); }
    }

    protected void addChildrenToFormatPanel() {
        if (!allComponentsCreated) {
            return;
        }
        formatPanel.add(dmsFormat);
        formatPanel.add(dmdFormat);
        formatPanel.add(ddFormat);
    }

    protected void addChildrenToLatitudeEditor() {
        if (!allComponentsCreated) {
            return;
        }
        latitudeEditor.add(latitudeDd, CoordinateFormat.dd.name());
        latitudeEditor.add(latitudeDms, CoordinateFormat.dms.name());
        latitudeEditor.add(latitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToLongitudeEditor() {
        if (!allComponentsCreated) {
            return;
        }
        longitudeEditor.add(longitudeDd, CoordinateFormat.dd.name());
        longitudeEditor.add(longitudeDms, CoordinateFormat.dms.name());
        longitudeEditor.add(longitudeDmd, CoordinateFormat.dmd.name());
    }

    protected void addChildrenToQuadrant1() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant1); }
    }

    protected void addChildrenToQuadrant2() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant2); }
    }

    protected void addChildrenToQuadrant3() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant3); }
    }

    protected void addChildrenToQuadrant4() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = quadrantBG; quadrant4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(quadrant4); }
    }

    protected void addChildrenToQuadrantEditor() {
        if (!allComponentsCreated) {
            return;
        }
        quadrantEditor.add(quadrant4);
        quadrantEditor.add(quadrant1);
        quadrantEditor.add(quadrant3);
        quadrantEditor.add(quadrant2);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setBean(model);
    }

    protected void createCoordinatesPanel() {
        $objectMap.put("coordinatesPanel", coordinatesPanel = new Table());
        
        coordinatesPanel.setName("coordinatesPanel");
    }

    protected void createDdFormat() {
        $objectMap.put("ddFormat", ddFormat = new JRadioButton());
        
        ddFormat.setName("ddFormat");
        ddFormat.setText(t("jaxx.coordinate.format.dd"));
        ddFormat.setToolTipText(t("jaxx.coordinate.format.dd.tip"));
    }

    protected void createDmdFormat() {
        $objectMap.put("dmdFormat", dmdFormat = new JRadioButton());
        
        dmdFormat.setName("dmdFormat");
        dmdFormat.setText(t("jaxx.coordinate.format.dmd"));
        dmdFormat.setToolTipText(t("jaxx.coordinate.format.dmd.tip"));
    }

    protected void createDmsFormat() {
        $objectMap.put("dmsFormat", dmsFormat = new JRadioButton());
        
        dmsFormat.setName("dmsFormat");
        dmsFormat.setText(t("jaxx.coordinate.format.dms"));
        dmsFormat.setToolTipText(t("jaxx.coordinate.format.dms.tip"));
    }

    protected void createFormatBG() {
        $objectMap.put("formatBG", formatBG = new JAXXButtonGroup());
    }

    protected void createFormatPanel() {
        $objectMap.put("formatPanel", formatPanel = new JPanel());
        
        formatPanel.setName("formatPanel");
        formatPanel.setLayout(new GridLayout(0,1,0,0));
    }

    protected void createLatitudeDd() {
        $objectMap.put("latitudeDd", latitudeDd = new AbsoluteDdCoordinateEditor());
        
        latitudeDd.setName("latitudeDd");
        latitudeDd.setPropertyDegree("ddDegree");
        latitudeDd.setPropertyDecimal("ddDecimal");
    }

    protected void createLatitudeDmd() {
        $objectMap.put("latitudeDmd", latitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        latitudeDmd.setName("latitudeDmd");
        latitudeDmd.setPropertyDegree("dmdDegree");
        latitudeDmd.setPropertyMinute("dmdMinute");
        latitudeDmd.setPropertyDecimal("dmdDecimal");
    }

    protected void createLatitudeDms() {
        $objectMap.put("latitudeDms", latitudeDms = new AbsoluteDmsCoordinateEditor());
        
        latitudeDms.setName("latitudeDms");
        latitudeDms.setPropertySecond("dmsSecond");
        latitudeDms.setPropertyDegree("dmsDegree");
        latitudeDms.setPropertyMinute("dmsMinute");
    }

    protected void createLatitudeEditor() {
        $objectMap.put("latitudeEditor", latitudeEditor = new JPanel());
        
        latitudeEditor.setName("latitudeEditor");
        latitudeEditor.setLayout(latitudeLayout);
    }

    protected void createLatitudeLabel() {
        $objectMap.put("latitudeLabel", latitudeLabel = new JLabel());
        
        latitudeLabel.setName("latitudeLabel");
        latitudeLabel.setText(t("jaxx.common.latitude"));
    }

    protected void createLatitudeLayout() {
        $objectMap.put("latitudeLayout", latitudeLayout = new CardLayout2Ext(this, "latitudeEditor"));
    }

    protected void createLatitudeModel() {
        $objectMap.put("latitudeModel", latitudeModel = model.getLatitudeModel());
    }

    protected void createLongitudeDd() {
        $objectMap.put("longitudeDd", longitudeDd = new AbsoluteDdCoordinateEditor());
        
        longitudeDd.setName("longitudeDd");
        longitudeDd.setPropertyDegree("ddDegree");
        longitudeDd.setPropertyDecimal("ddDecimal");
    }

    protected void createLongitudeDmd() {
        $objectMap.put("longitudeDmd", longitudeDmd = new AbsoluteDmdCoordinateEditor());
        
        longitudeDmd.setName("longitudeDmd");
        longitudeDmd.setPropertyDegree("dmdDegree");
        longitudeDmd.setPropertyMinute("dmdMinute");
        longitudeDmd.setPropertyDecimal("dmdDecimal");
    }

    protected void createLongitudeDms() {
        $objectMap.put("longitudeDms", longitudeDms = new AbsoluteDmsCoordinateEditor());
        
        longitudeDms.setName("longitudeDms");
        longitudeDms.setPropertySecond("dmsSecond");
        longitudeDms.setPropertyDegree("dmsDegree");
        longitudeDms.setPropertyMinute("dmsMinute");
    }

    protected void createLongitudeEditor() {
        $objectMap.put("longitudeEditor", longitudeEditor = new JPanel());
        
        longitudeEditor.setName("longitudeEditor");
        longitudeEditor.setLayout(longitudeLayout);
    }

    protected void createLongitudeLabel() {
        $objectMap.put("longitudeLabel", longitudeLabel = new JLabel());
        
        longitudeLabel.setName("longitudeLabel");
        longitudeLabel.setText(t("jaxx.common.longitude"));
    }

    protected void createLongitudeLayout() {
        $objectMap.put("longitudeLayout", longitudeLayout = new CardLayout2Ext(this, "longitudeEditor"));
    }

    protected void createLongitudeModel() {
        $objectMap.put("longitudeModel", longitudeModel = model.getLongitudeModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorModel.class));
    }

    protected void createQuadrant1() {
        $objectMap.put("quadrant1", quadrant1 = new JToggleButton());
        
        quadrant1.setName("quadrant1");
        quadrant1.setText(t("jaxx.common.quadrant1"));
    }

    protected void createQuadrant2() {
        $objectMap.put("quadrant2", quadrant2 = new JToggleButton());
        
        quadrant2.setName("quadrant2");
        quadrant2.setText(t("jaxx.common.quadrant2"));
    }

    protected void createQuadrant3() {
        $objectMap.put("quadrant3", quadrant3 = new JToggleButton());
        
        quadrant3.setName("quadrant3");
        quadrant3.setText(t("jaxx.common.quadrant3"));
    }

    protected void createQuadrant4() {
        $objectMap.put("quadrant4", quadrant4 = new JToggleButton());
        
        quadrant4.setName("quadrant4");
        quadrant4.setText(t("jaxx.common.quadrant4"));
    }

    protected void createQuadrantBG() {
        $objectMap.put("quadrantBG", quadrantBG = new JAXXButtonGroup());
    }

    protected void createQuadrantEditor() {
        $objectMap.put("quadrantEditor", quadrantEditor = new JPanel());
        
        quadrantEditor.setName("quadrantEditor");
        quadrantEditor.setLayout(new GridLayout(2,2,0,0));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CoordinatesEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCoordinateEditorTopPanel();
        addChildrenToValidator();
        addChildrenToQuadrantEditor();
        addChildrenToQuadrant4();
        addChildrenToQuadrant1();
        addChildrenToQuadrant3();
        addChildrenToQuadrant2();
        addChildrenToCoordinatesPanel();
        addChildrenToLatitudeEditor();
        addChildrenToLongitudeEditor();
        addChildrenToFormatPanel();
        addChildrenToDmsFormat();
        addChildrenToDmdFormat();
        addChildrenToDdFormat();
        
        // apply 33 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        { quadrant4.putClientProperty("$value", new Integer(4));  Object $buttonGroup = quadrant4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant1.putClientProperty("$value", new Integer(1));  Object $buttonGroup = quadrant1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant3.putClientProperty("$value", new Integer(3));  Object $buttonGroup = quadrant3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { quadrant2.putClientProperty("$value", new Integer(2));  Object $buttonGroup = quadrant2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        latitudeLabel.setLabelFor(latitudeEditor);
        latitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDd.setBean(latitudeModel);
        latitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDms.setBean(latitudeModel);
        latitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.latitude.tip"));
        latitudeDmd.setBean(latitudeModel);
        longitudeLabel.setLabelFor(longitudeEditor);
        longitudeDd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDd.setBean(longitudeModel);
        longitudeDms.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDms.setBean(longitudeModel);
        longitudeDmd.setShowResetTip(t("jaxx.coordinate.action.reset.longitude.tip"));
        longitudeDmd.setBean(longitudeModel);
        { dmsFormat.putClientProperty("$value", CoordinateFormat.dms);  Object $buttonGroup = dmsFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { dmdFormat.putClientProperty("$value", CoordinateFormat.dmd);  Object $buttonGroup = dmdFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ddFormat.putClientProperty("$value", CoordinateFormat.dd);  Object $buttonGroup = ddFormat.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("coordinateEditorTopPanel", coordinateEditorTopPanel);
        createModel();
        createLatitudeModel();
        createLongitudeModel();
        createValidator();
        createLatitudeLayout();
        createLongitudeLayout();
        createQuadrantEditor();
        createQuadrant4();
        createQuadrant1();
        createQuadrant3();
        createQuadrant2();
        createCoordinatesPanel();
        createLatitudeLabel();
        createLatitudeEditor();
        createLatitudeDd();
        createLatitudeDms();
        createLatitudeDmd();
        createLongitudeLabel();
        createLongitudeEditor();
        createLongitudeDd();
        createLongitudeDms();
        createLongitudeDmd();
        createFormatPanel();
        createDmsFormat();
        createDmdFormat();
        createDdFormat();
        createQuadrantBG();
        createFormatBG();
        // inline creation of coordinateEditorTopPanel
        setName("coordinateEditorTopPanel");
        
        // registers 33 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 33 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_FORMAT, true) {
        
            @Override
            public void applyDataBinding() {
                if (formatBG != null) {
                    formatBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (formatBG != null) {
                    model.setFormat((CoordinateFormat)formatBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (formatBG != null) {
                    formatBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODEL_QUADRANT, true) {
        
            @Override
            public void applyDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (quadrantBG != null) {
                    model.setQuadrant((Integer)quadrantBG.getSelectedValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (quadrantBG != null) {
                    quadrantBG.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeLayout.setSelected(String.valueOf(model.getFormat()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT4_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant4.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT4_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant4.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 4));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT1_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant1.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT1_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant1.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT3_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant3.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT3_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant3.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 3));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUADRANT2_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                quadrant2.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUADRANT2_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quadrant2.setSelected(handler.isQuadrantSelected(model.getQuadrant(), 2));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDd.setValue(latitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DMS_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDms.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDms.setValue(latitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LATITUDE_DMD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                latitudeDmd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (latitudeModel != null) {
                    latitudeDmd.setValue(latitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (latitudeModel != null) {
                    latitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LATITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    latitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDd.setValue(longitudeModel.getDd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DMS_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDms.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dms", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDms.setValue(longitudeModel.getDms());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dms", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMS_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDms.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LONGITUDE_DMD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                longitudeDmd.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.addPropertyChangeListener("dmd", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (longitudeModel != null) {
                    longitudeDmd.setValue(longitudeModel.getDmd());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (longitudeModel != null) {
                    longitudeModel.removePropertyChangeListener("dmd", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LONGITUDE_DMD_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetButton", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    longitudeDmd.setShowReset(model.isShowResetButton());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetButton", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMS_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmsFormat.setSelected(model.getFormat() == CoordinateFormat.dms);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DMD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    dmdFormat.setSelected(model.getFormat() == CoordinateFormat.dmd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DD_FORMAT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("format", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ddFormat.setSelected(model.getFormat() == CoordinateFormat.dd);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("format", this);
                }
            }
        });
    }

}