/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorEvent;
import jaxx.runtime.validator.BeanValidatorListener;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.SimpleBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class BeanValidatorTest {
    protected static final Log log = LogFactory.getLog(BeanValidator.class);
    protected BeanValidator<SimpleBean> validator;
    protected SimpleBean bean;
    BeanValidatorListenerImpl fatalListener;
    BeanValidatorListenerImpl errorListener;
    BeanValidatorListenerImpl warningListener;
    BeanValidatorListenerImpl infoListener;
    private static final String STRING_VALUE_FATAL = "stringValue.fatal";
    private static final String STRING_VALUE_ERROR = "stringValue.error";
    private static final String STRING_VALUE_WARNING = "stringValue.warning";
    private static final String INT_VALUE_FATAL = "intValue.fatal";
    private static final String INT_VALUE_ERROR = "intValue.error";
    private static final String INT_VALUE_INFO = "intValue.info";

    @Before
    public void setUp() {
        this.bean = new SimpleBean();
        this.validator = new BeanValidator(SimpleBean.class, null);
        this.fatalListener = new BeanValidatorListenerImpl(BeanValidatorScope.FATAL);
        this.validator.addBeanValidatorListener((BeanValidatorListener)this.fatalListener);
        this.errorListener = new BeanValidatorListenerImpl(BeanValidatorScope.ERROR);
        this.validator.addBeanValidatorListener((BeanValidatorListener)this.errorListener);
        this.warningListener = new BeanValidatorListenerImpl(BeanValidatorScope.WARNING);
        this.validator.addBeanValidatorListener((BeanValidatorListener)this.warningListener);
        this.infoListener = new BeanValidatorListenerImpl(BeanValidatorScope.INFO);
        this.validator.addBeanValidatorListener((BeanValidatorListener)this.infoListener);
    }

    @After
    public void tearDown() {
        this.bean = null;
        if (this.validator != null) {
            this.validator.setBean(null);
            this.validator = null;
        }
    }

    @Test
    public void testValidate() {
        this.assertMessages(this.fatalListener, new String[0]);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, new String[0]);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.validator.setBean((Object)this.bean);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("one");
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("oneone");
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setIntValue(1);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setIntValue(10);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, new String[0]);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue(null);
        this.bean.setIntValue(0);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("5");
        this.bean.setIntValue(5);
        this.assertMessages(this.fatalListener, new String[0]);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
    }

    @Test
    public void testConvert() {
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, new String[0]);
        this.assertMessages(this.infoListener, new String[0]);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.validator.setBean((Object)this.bean);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        Object value = this.validator.convert("intValue", "abc", Class.class);
        Assert.assertNull((Object)value);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, STRING_VALUE_ERROR, "error.convertor.class");
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setStringValue("one");
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, "error.convertor.class");
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        value = this.validator.convert("intValue", "3", Integer.class);
        this.bean.setIntValue((Integer)value);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, new String[0]);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
        this.bean.setIntValue(-1);
        this.assertMessages(this.fatalListener, STRING_VALUE_FATAL, INT_VALUE_FATAL);
        this.assertMessages(this.errorListener, INT_VALUE_ERROR);
        this.assertMessages(this.warningListener, STRING_VALUE_WARNING);
        this.assertMessages(this.infoListener, INT_VALUE_INFO);
        if (log.isInfoEnabled()) {
            log.info((Object)"-----------------------------------------------");
        }
    }

    void assertMessages(BeanValidatorListenerImpl listener, String ... expected) {
        List<String> actual = listener.getMessages();
        Assert.assertEquals((String)(" shoudl have " + Arrays.toString(expected) + " but had " + actual), (long)expected.length, (long)actual.size());
        for (String m : expected) {
            Assert.assertEquals((String)("could not find " + m + " in " + actual), (Object)true, (Object)actual.contains(m));
        }
    }

    class BeanValidatorListenerImpl
    implements BeanValidatorListener {
        final BeanValidatorScope scope;
        List<String> messages = new ArrayList<String>();

        public BeanValidatorListenerImpl(BeanValidatorScope scope) {
            this.scope = scope;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void onFieldChanged(BeanValidatorEvent event) {
            Object[] messagesToAdd;
            if (this.scope != event.getScope()) {
                return;
            }
            Object[] messagesToDelete = event.getMessagesToDelete();
            if (messagesToDelete != null && messagesToDelete.length > 0) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(event.getScope() + " messages to delete : " + Arrays.toString(messagesToDelete)));
                }
                for (Object m : messagesToDelete) {
                    this.messages.remove(m);
                }
            }
            if ((messagesToAdd = event.getMessagesToAdd()) != null && messagesToAdd.length > 0) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(event.getScope() + " messages to add : " + Arrays.toString(messagesToAdd)));
                }
                this.messages.addAll(Arrays.asList(messagesToAdd));
            }
        }
    }
}

