/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.wizard.ext;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.swing.wizard.WizardUI;
import org.nuiton.jaxx.runtime.swing.wizard.WizardUtil;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardExtModel;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardExtStep;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardExtUI;
import org.nuiton.jaxx.runtime.swing.wizard.ext.WizardState;

public class WizardExtUtil
extends WizardUtil {
    private static final Log log = LogFactory.getLog(WizardUI.class);

    protected WizardExtUtil() {
    }

    public static boolean acceptStates(WizardState state, WizardState ... accepted) {
        for (WizardState s : accepted) {
            if (s != state) continue;
            return true;
        }
        return false;
    }

    public static boolean rejectStates(WizardState state, WizardState ... rejected) {
        for (WizardState s : rejected) {
            if (s != state) continue;
            return false;
        }
        return true;
    }

    public static <E extends WizardExtStep, M extends WizardExtModel<E>> void installWizardUIListeners(WizardExtUI<E, M> ui) {
        PropertyChangeListener dispatcher = evt -> {
            String propertyName = evt.getPropertyName();
            if ("wasStarted".equals(propertyName)) {
                ui.onWasStarted();
                return;
            }
            WizardExtModel model = (WizardExtModel)evt.getSource();
            if ("steps".equals(propertyName)) {
                List steps = (List)evt.getNewValue();
                ui.onStepsChanged(steps.toArray((WizardExtStep[])Array.newInstance(model.getStepClass(), steps.size())));
                return;
            }
            if ("step".equals(propertyName)) {
                ui.onStepChanged((WizardExtStep)evt.getOldValue(), (WizardExtStep)evt.getNewValue());
                return;
            }
            if ("validStep".equals(propertyName)) {
                Boolean value = (Boolean)evt.getNewValue();
                if (value == null || !value.booleanValue()) {
                    ui.onModelStateChanged(WizardState.NEED_FIX);
                } else {
                    ui.onModelStateChanged(WizardState.PENDING);
                }
                return;
            }
            if ("modelState".equals(propertyName)) {
                ui.onModelStateChanged((WizardState)((Object)((Object)evt.getNewValue())));
                return;
            }
            if ("stepState".equals(propertyName)) {
                IndexedPropertyChangeEvent e = (IndexedPropertyChangeEvent)evt;
                int stepIndex = e.getIndex();
                WizardExtStep step = (WizardExtStep)model.getSteps().get(stepIndex);
                ui.onOperationStateChanged(step, (WizardState)((Object)((Object)evt.getNewValue())));
            }
        };
        WizardExtModel model = (WizardExtModel)ui.getModel();
        log.info((Object)("Adding dispatcher " + dispatcher + " to model " + model));
        model.addPropertyChangeListener(dispatcher);
    }
}

