/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import org.nuiton.jaxx.runtime.swing.Item;

public class JAXXList
extends JList<Item> {
    private static final long serialVersionUID = 1L;

    public JAXXList() {
        this.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Item item;
                String label;
                ListModel model = list.getModel();
                if (model instanceof JAXXListModel && (label = (item = (Item)((JAXXListModel)model).items.get(index)).getLabel()) != null) {
                    value = label;
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.addListSelectionListener(e -> {
            ListModel model = this.getModel();
            if (model instanceof JAXXListModel) {
                List items = ((JAXXListModel)model).items;
                for (int i = items.size() - 1; i >= 0; --i) {
                    Item item;
                    boolean selected = this.isSelectedIndex(i);
                    if (selected == (item = (Item)items.get(i)).isSelected()) continue;
                    item.setSelected(selected);
                }
            }
        });
    }

    @Override
    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        super.fireSelectionValueChanged(firstIndex, lastIndex, isAdjusting);
    }

    public void setItems(List<Item> items) {
        this.setModel(new JAXXListModel(items));
        ArrayList<Integer> selectedIndexList = new ArrayList<Integer>();
        for (int i = 0; i < items.size(); ++i) {
            if (!items.get(i).isSelected()) continue;
            selectedIndexList.add(i);
        }
        int[] selectedIndices = new int[selectedIndexList.size()];
        for (int i = 0; i < selectedIndexList.size(); ++i) {
            selectedIndices[i] = (Integer)selectedIndexList.get(i);
        }
        this.setSelectedIndices(selectedIndices);
    }

    public List<Item> getItems() {
        if (this.getModel() instanceof JAXXListModel) {
            return ((JAXXListModel)this.getModel()).getItems();
        }
        return null;
    }

    public void setSelectedValue(Object value) {
        super.setSelectedValue(value, true);
    }

    public void setSelectedValues(Object[] values) {
        if (values != null) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            ListModel model = this.getModel();
            block0: for (int i = 0; i < model.getSize(); ++i) {
                Object o = model.getElementAt(i);
                for (Object value : values) {
                    if (!o.equals(value)) continue;
                    selectedIndices.add(i);
                    continue block0;
                }
            }
            int[] ints = new int[selectedIndices.size()];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = (Integer)selectedIndices.get(i);
            }
            this.setSelectedIndices(ints);
        } else {
            this.setSelectedIndex(-1);
        }
    }

    public void setSelectedItem(Item item) {
        super.setSelectedValue(item.getValue(), true);
    }

    public void setSelectedItems(List<Item> itemsToSelect) {
        if (itemsToSelect != null) {
            List<Item> items = this.getItems();
            int[] indices = new int[itemsToSelect.size()];
            int i = 0;
            for (Item item : itemsToSelect) {
                indices[i] = items.indexOf(item);
                ++i;
            }
            super.setSelectedIndices(indices);
        }
    }

    public Item getSelectedItem() {
        Object selected = super.getSelectedValue();
        return this.findItem(selected);
    }

    public List<Item> getSelectedItems() {
        List selected = super.getSelectedValuesList();
        ArrayList<Item> itemsSelected = new ArrayList<Item>();
        for (Object s : selected) {
            itemsSelected.add(this.findItem(s));
        }
        return itemsSelected;
    }

    public Item findItem(Object value) {
        List<Item> items = this.getItems();
        if (items != null) {
            for (Item i : items) {
                if (!i.getValue().equals(value)) continue;
                return i;
            }
        }
        return null;
    }

    public void addItem(Item item) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.add(item);
            this.setItems(items);
        }
    }

    public void addAllItems(Collection<Item> itemsToAdd) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.addAll(itemsToAdd);
            this.setItems(items);
        }
    }

    public void removeItem(Item item) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.remove(item);
            this.setItems(items);
        }
    }

    public void removeAllItems(Collection<Item> itemsToRemove) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.removeAll(itemsToRemove);
            this.setItems(items);
        }
    }

    public void fillList(Collection<?> data, Collection<?> selects) {
        if (selects == null) {
            selects = Collections.EMPTY_LIST;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            Object select;
            boolean selected = false;
            Iterator iterator = selects.iterator();
            while (iterator.hasNext() && !(selected = o.equals(select = iterator.next()))) {
            }
            items.add(new Item(o.toString(), o.toString(), o, selected));
        }
        this.setItems(items);
    }

    public void fillList(Collection<?> data, Object select) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            boolean selected = o.equals(select);
            items.add(new Item(o.toString(), o.toString(), o, selected));
        }
        this.setItems(items);
    }

    public void fillList(Collection<?> data, Object select, String methodName) {
        Method m = null;
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            boolean selected = o.equals(select);
            if (m == null) {
                try {
                    m = o.getClass().getMethod(methodName, new Class[0]);
                    m.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("could not find method " + methodName + " on " + o.getClass());
                }
            }
            try {
                items.add(new Item(o.toString(), (String)m.invoke(o, new Object[0]), o, selected));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.setItems(items);
    }

    public void fillList(Collection<?> data, Collection<?> selects, String methodName) {
        Method m = null;
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            boolean selected = selects.contains(o);
            if (m == null) {
                try {
                    m = o.getClass().getMethod(methodName, new Class[0]);
                    m.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("could not find method " + methodName + " on " + o.getClass());
                }
            }
            try {
                items.add(new Item(o.toString(), (String)m.invoke(o, new Object[0]), o, selected));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.setItems(items);
    }

    public class JAXXListModel
    extends AbstractListModel<Item> {
        private final List<Item> items;
        private static final long serialVersionUID = -1598924187490122036L;

        public JAXXListModel(List<Item> items) {
            this.items = items;
            PropertyChangeListener listener = e -> {
                if (e.getPropertyName().equals("selected")) {
                    int[] newSelection;
                    Item item = (Item)e.getSource();
                    int itemIndex = this.items.indexOf(item);
                    int[] oldSelection = JAXXList.this.getSelectedIndices();
                    int index = -1;
                    for (int i = 0; i < oldSelection.length; ++i) {
                        if (oldSelection[i] != itemIndex) continue;
                        index = i;
                        break;
                    }
                    if (item.isSelected()) {
                        if (index != -1) {
                            return;
                        }
                        newSelection = new int[oldSelection.length + 1];
                        System.arraycopy(oldSelection, 0, newSelection, 0, oldSelection.length);
                        newSelection[newSelection.length - 1] = itemIndex;
                    } else {
                        if (index == -1) {
                            return;
                        }
                        newSelection = new int[oldSelection.length - 1];
                        System.arraycopy(oldSelection, 0, newSelection, 0, index);
                        System.arraycopy(oldSelection, index + 1, newSelection, index, oldSelection.length - 1 - index);
                    }
                    JAXXList.this.setSelectedIndices(newSelection);
                } else {
                    for (int i = 0; i < this.getSize(); ++i) {
                        if (this.getElementAt(i) != ((Item)e.getSource()).getValue()) continue;
                        this.fireContentsChanged(this, i, i);
                        if (JAXXList.this.isSelectedIndex(i)) {
                            JAXXList.this.fireSelectionValueChanged(i, i, false);
                        }
                        return;
                    }
                }
            };
            for (Item item : items) {
                item.addPropertyChangeListener(listener);
            }
        }

        public List<Item> getItems() {
            return this.items;
        }

        @Override
        public Item getElementAt(int i) {
            return this.items.get(i);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }
    }
}

