/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.nav.treetable;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import jaxx.runtime.swing.nav.treetable.NavTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class NavTreeTableBridge<N extends NavTreeTableNode<N>>
implements NavBridge<NavTreeTableModel, N> {
    private static final Log log = LogFactory.getLog(NavTreeTableBridge.class);
    protected NavTreeTableModel model;

    @Override
    public NavTreeTableModel getModel() {
        return this.model;
    }

    @Override
    public N getRoot() {
        return (N)((NavTreeTableNode)this.model.getRoot());
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.model.isLeaf(node);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.model.getChildCount(parent);
    }

    @Override
    public N getChild(Object parent, int index) {
        return (N)((NavTreeTableNode)this.model.getChild(parent, index));
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.model.getIndexOfChild(parent, child);
    }

    @Override
    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.model.getPathToRoot((TreeTableNode)aNode);
    }

    @Override
    public void setModel(NavTreeTableModel model) {
        this.model = model;
    }

    @Override
    public void setRoot(N node) {
        this.model.setRoot((TreeTableNode)node);
    }

    @Override
    public void insertNodeInto(N newChild, N parent, int index) {
        ((NavTreeTableNode)parent).insert(newChild, index);
        this.model.getModelSupport().fireChildAdded(this.getTreePath((TreeNode)parent), index, newChild);
    }

    @Override
    public void removeNodeFromParent(N node) {
        TreeNode parent = ((NavTreeTableNode)node).getParent();
        int index = parent.getIndex((TreeNode)node);
        if (index == -1) {
            throw new IllegalArgumentException("Node " + node + " is not in tree");
        }
        ((NavTreeTableNode)parent).remove(node);
        this.model.getModelSupport().fireTreeStructureChanged(this.getTreePath(parent));
    }

    @Override
    public void reload(N node) {
        this.model.getModelSupport().fireTreeStructureChanged(this.getTreePath((TreeNode)node));
    }

    @Override
    public boolean canLoadChild(N node) {
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.model.valueForPathChanged(path, newValue);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        this.model.nodeStructureChanged((NavTreeTableNode)node);
    }

    @Override
    public void nodeChanged(TreeNode node) {
        this.model.nodeChanged((NavTreeTableNode)node);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        NavTreeTableNode tableNode = (NavTreeTableNode)node;
        Object[] children = this.getChildren(tableNode, childIndices);
        this.model.getModelSupport().fireChildrenChanged(this.getTreePath(tableNode), childIndices, children);
    }

    @Override
    public void nodesWereInserted(N parent, int[] indices) {
        Object[] children = this.getChildren((NavTreeTableNode<?>)parent, indices);
        this.model.getModelSupport().fireChildrenAdded(this.getTreePath((TreeNode)parent), indices, children);
    }

    @Override
    public void nodeWereInserted(N parentNode, int index, N node) {
        this.model.getModelSupport().fireChildAdded(this.getTreePath((TreeNode)parentNode), index, node);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        this.model.getModelSupport().fireChildrenRemoved(this.getTreePath(node), childIndices, removedChildren);
    }

    @Override
    public void notifyChildNodesInserted(N node) {
        int count = node.getChildCount();
        if (count < 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip for leaf node : " + node));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Notify for node : " + node + ", " + count + " child(s) inserted."));
        }
        int[] indices = new int[count];
        for (int i = 0; i < count; ++i) {
            indices[i] = i;
        }
        this.nodesWereInserted(node, indices);
        Enumeration childs = ((NavTreeTableNode)node).children();
        while (childs.hasMoreElements()) {
            NavTreeTableNode child = (NavTreeTableNode)childs.nextElement();
            this.notifyChildNodesInserted((N)child);
        }
    }

    @Override
    public void notifyNodeInserted(N node) {
        TreeNode parent = ((NavTreeTableNode)node).getParent();
        if (parent != null) {
            int index = parent.getIndex((TreeNode)node);
            if (index == -1) {
                throw new IllegalArgumentException("Node " + node + " is not in tree");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notify for node : " + node + ", for parent [" + parent + "] child  " + index + " inserted."));
            }
            this.nodesWereInserted(parent, new int[]{index});
            this.notifyChildNodesInserted(node);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.model.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.model.removeTreeModelListener(l);
    }

    @Override
    public TreeModelListener[] getTreeModelListeners() {
        return this.model.getModelSupport().getTreeModelListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        TreeModelListener[] treeModelListeners = this.getTreeModelListeners();
        ArrayList<TreeModelListener> result = new ArrayList<TreeModelListener>();
        for (TreeModelListener listener : treeModelListeners) {
            if (!listener.getClass().isAssignableFrom(listenerType)) continue;
            result.add(listener);
        }
        return (EventListener[])result.toArray();
    }

    protected Object[] getChildren(NavTreeTableNode<?> tableNode, int[] childIndices) {
        int size = childIndices.length;
        Object[] children = new Object[size];
        for (int i = 0; i < size; ++i) {
            int index = childIndices[i];
            TreeNode child = tableNode.getChildAt(index);
            children[i] = child;
        }
        return children;
    }

    protected TreePath getTreePath(TreeNode node) {
        return new TreePath(this.getPathToRoot(node));
    }
}

