/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: DataBindingListener.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5/jaxx-runtime/src/main/java/jaxx/runtime/DataBindingListener.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;


/**
 * A <code>PropertyChangeListener</code> which processes a data binding when it receives a
 * <code>PropertyChangeEvent</code>.
 */
public class DataBindingListener implements PropertyChangeListener {
    private JAXXObject object;

    private String dest;

    /**
     * Creates a new <code>DataBindingListener</code> which will run the given data binding
     * when it receives a <code>PropertyChangeEvent</code>.
     *
     * @param object the object in which the data binding exists
     * @param dest   the name of the data binding to run
     */
    public DataBindingListener(JAXXObject object, String dest) {
        this.object = object;
        this.dest = dest;
    }


    /**
     * Processes the data binding in response to a <code>PropertyChangeEvent</code>.
     *
     * @param e the event which triggered the binding
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        object.processDataBinding(dest);

        // for now, handle dependency changes by always removing & reapplying
        // the binding.  We should be more efficient and only do this when it's
        // actually necessary
        object.removeDataBinding(dest);
        object.applyDataBinding(dest);
    }
}