/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: BooleanCellRenderer.java 2377 2012-07-03 13:39:06Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.5/jaxx-runtime/src/main/java/jaxx/runtime/swing/renderer/BooleanCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.renderer;

import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import java.awt.Color;
import java.awt.Component;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.5
 */
public class BooleanCellRenderer extends JPanel implements TableCellRenderer {

    private static final long serialVersionUID = 1L;

    protected TableCellRenderer defaultDelegate;

    protected JCheckBox checkBox;

    public BooleanCellRenderer(TableCellRenderer delegate) {
        //super(new BorderLayout());
        this.checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(JLabel.CENTER);
        checkBox.setBorderPainted(true);
        this.defaultDelegate = delegate;
    }

    public BooleanCellRenderer(TableCellRenderer delegate, Icon icon) {
        //super(new BorderLayout());
        this.checkBox = new JCheckBox(icon);
        checkBox.setHorizontalAlignment(JLabel.CENTER);
        checkBox.setVerticalTextPosition(JLabel.TOP);
        checkBox.setBorderPainted(true);
        this.defaultDelegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ((JComponent) defaultDelegate).setBackground(null);
        JComponent render = (JComponent) defaultDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            setForeground(table.getSelectionForeground());
            setBackground(table.getSelectionBackground());
        } else {
            setForeground(render.getForeground());
            setBackground(render.getBackground());
            //fixme make this works... and remove the test
            if (row % 2 == 1) {
                setBackground(Color.WHITE);
            }
        }
        checkBox.setSelected((value != null && (Boolean) value));
        setBorder(render.getBorder());
        return checkBox;
    }
}
