/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.nav.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeNode;

public class NavTreeHelper<N extends NavTreeNode<N>>
extends NavHelper<DefaultTreeModel, JTree, NavTreeBridge<N>, N> {
    public NavTreeHelper() {
        this(new NavTreeBridge());
    }

    public NavTreeHelper(NavTreeBridge<N> bridge) {
        super(bridge);
    }

    @Override
    public void scrollPathToVisible(TreePath path) {
        ((JTree)this.getUI()).scrollPathToVisible(path);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        ((JTree)this.getUI()).setSelectionPath(path);
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        ((JTree)this.getUI()).addSelectionPaths(paths);
    }

    @Override
    public void addSelectionPath(TreePath path) {
        ((JTree)this.getUI()).addSelectionPath(path);
    }

    @Override
    public void removeSelectionPaths(TreePath[] path) {
        ((JTree)this.getUI()).removeSelectionPaths(path);
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        ((JTree)this.getUI()).removeSelectionPath(path);
    }

    @Override
    public TreeSelectionModel getSelectionModel() {
        return ((JTree)this.getUI()).getSelectionModel();
    }

    @Override
    public boolean isExpanded(TreePath pathToExpand) {
        return ((JTree)this.getUI()).isExpanded(pathToExpand);
    }

    @Override
    public void expandPath(TreePath pathToExpand) {
        ((JTree)this.getUI()).expandPath(pathToExpand);
    }

    @Override
    public AbstractNavTreeCellRenderer<DefaultTreeModel, N> getTreeCellRenderer() {
        JTree t = (JTree)this.getUI();
        if (t == null) {
            return null;
        }
        TreeCellRenderer r = t.getCellRenderer();
        if (r instanceof AbstractNavTreeCellRenderer) {
            return (AbstractNavTreeCellRenderer)r;
        }
        return null;
    }

    @Override
    public N getSelectedNode() {
        JTree tree = (JTree)this.getUI();
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        NavTreeNode node = null;
        if (path != null) {
            node = (NavTreeNode)path.getLastPathComponent();
        }
        return (N)node;
    }

    @Override
    public List<N> getSelectedNodes() {
        JTree tree = (JTree)this.getUI();
        if (tree == null) {
            return null;
        }
        TreePath[] paths = tree.getSelectionPaths();
        ArrayList<NavTreeNode> nodes = new ArrayList<NavTreeNode>();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path == null) continue;
                nodes.add((NavTreeNode)path.getLastPathComponent());
            }
        }
        return nodes;
    }

    @Override
    public void setUI(JTree tree, boolean addExpandTreeListener, boolean addOneClickSelectionListener, TreeSelectionListener listener, TreeWillExpandListener willExpandListener) {
        this.setUI(tree);
        if (willExpandListener != null) {
            tree.addTreeWillExpandListener(willExpandListener);
        }
        if (addExpandTreeListener) {
            tree.addTreeWillExpandListener(this.expandListener);
        }
        if (listener != null) {
            tree.addTreeSelectionListener(listener);
        }
        if (addOneClickSelectionListener) {
            tree.addTreeSelectionListener(this.selectionListener);
        }
    }

    @Override
    protected DefaultTreeModel createModel(N node, Object ... extraArgs) {
        NavTreeBridge bridge = (NavTreeBridge)this.getBridge();
        DefaultTreeModel model = bridge.getModel();
        if (model == null) {
            model = new DefaultTreeModel((TreeNode)node);
            bridge.setModel(model);
            bridge.addTreeModelListener(this.treeModelListener);
        } else {
            bridge.setRoot(node);
        }
        bridge.nodeStructureChanged((TreeNode)this.getRootNode());
        return model;
    }
}

