/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import javax.swing.JComponent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorMessage;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.SwingValidator;

public class SwingValidatorMessage
extends BeanValidatorMessage<SwingValidatorMessage> {
    protected JComponent editor;
    protected String fieldName;

    public SwingValidatorMessage(SwingValidator<?> validator, BeanValidatorField<?> field, String message, BeanValidatorScope scope, JComponent editor) {
        super(validator, field, message, scope);
        this.fieldName = field.getName();
        this.editor = editor;
    }

    public SwingValidatorMessage(SwingValidator<?> validator, String fieldName, String message, BeanValidatorScope scope, JComponent editor) {
        super(validator, null, message, scope);
        this.fieldName = fieldName;
        this.editor = editor;
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public int compareTo(SwingValidatorMessage o) {
        int result = this.getScope().compareTo(o.getScope());
        if (result == 0 && (result = this.fieldName.compareTo(o.getFieldName())) == 0) {
            result = this.message.compareTo(o.getMessage());
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwingValidatorMessage that = (SwingValidatorMessage)o;
        return this.fieldName.equals(that.fieldName) && this.message.equals(that.message) && this.scope == that.scope;
    }

    @Override
    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.scope.hashCode();
        return result;
    }

    @Override
    public String toString() {
        String s = (Object)((Object)this.scope) + " - " + (this.field == null ? this.message : this.field.getI18nError(this.message));
        if (this.editor == null) {
            return s;
        }
        return this.editor.getName() + " : " + s;
    }
}

