/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: DecoratorTableCellRenderer.java 2086 2010-09-11 19:39:49Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/renderer/DecoratorTableCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.renderer;

import jaxx.runtime.decorator.Decorator;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import java.awt.Component;

/**
 * A {@link TableCellRenderer} which compute text with the given {@link #decorator}
 * and leave the hand to the {@link #delegate} to perform the visual renderer.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.7.2 (was previously {@code jaxx.runtime.swing.DecoratorTableCellRenderer}).
 */
public class DecoratorTableCellRenderer implements TableCellRenderer {

    /** Delegate cell renderer */
    protected TableCellRenderer delegate;

    /** Decorator to produce text to render */
    protected Decorator<?> decorator;

    public DecoratorTableCellRenderer(Decorator<?> decorator) {
        this(new DefaultTableCellRenderer(), decorator);
    }

    public DecoratorTableCellRenderer(TableCellRenderer delegate, Decorator<?> decorator) {
        this.delegate = delegate;
        this.decorator = decorator;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
        if (value != null) {
            value = decorator.toString(value);
        }
        return delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
    }
}
