/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.decorator;

import java.util.Comparator;
import jaxx.runtime.decorator.JXPathDecorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiJXPathDecorator<O>
extends JXPathDecorator<O> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MultiJXPathDecorator.class);
    protected JXPathDecorator.Context<O>[] contexts;
    protected String separator;
    protected String separatorReplacement;

    protected MultiJXPathDecorator(Class<O> internalClass, String expression, String separator, String separatorReplacement, JXPathDecorator.Context<O>[] contexts) throws IllegalArgumentException, NullPointerException {
        super(internalClass, expression, null);
        this.separator = separator;
        this.separatorReplacement = separatorReplacement;
        this.contexts = contexts;
        this.setContextIndex(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)(expression + " --> " + this.context));
        }
    }

    public void setContextIndex(int index) {
        this.ensureContextIndex(this, index);
        this.setContext(this.contexts[index]);
    }

    public int getNbContext() {
        return this.contexts.length;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getSeparatorReplacement() {
        return this.separatorReplacement;
    }

    @Override
    protected Comparator<O> getComparator(int pos) {
        this.ensureContextIndex(this, pos);
        JXPathDecorator.Context<O> context1 = this.contexts[pos];
        return context1.getComparator(0);
    }

    protected void ensureContextIndex(MultiJXPathDecorator<?> decorator, int pos) {
        if (pos < -1 || pos > decorator.contexts.length) {
            throw new ArrayIndexOutOfBoundsException("context index " + pos + " is out of bound, can be inside [" + 0 + "," + decorator.contexts.length + "]");
        }
    }
}

