package jaxx.runtime.swing;

import jaxx.runtime.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import org.nuiton.util.Resource;
import jaxx.runtime.SwingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AboutPanel extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.AboutPanel.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz2/cRBTHJ0s2yWabpk3LD0GDUogEVVVvf9BGkKolBKom2tC0idSqe+nYnmSnnfUMM+PE6QEhuCLUEwcuwJ0jd4Q4cuLK/4AQ/wFvxl57nTquVefg3bx57zPvvZn39f7yD2oqic4+xlHkyDDQdECc9ZUHD+64j4mnPyXKk1RoLlH8N9ZAjR5q+6ldafRur2vCO0l4Z5UPBA9IMBK93EXTSh8wovqEaI1ejSM8pTpbqXk5EqEc0tJkimg//fdv45n/1c8NhCIBWb0BJSy8KCqrYLyLGtTXaA522sMdhoNdSEPSYBfynDG2VYaV+hwPyBfoSzTZRRMCS4Bp9E71Ui3DxkdCo8nFbewyclGj+Vyiah+2dVZcHupNHBAmhI2Z0KipqWZEoxMmIcck6cRJZi5T1OPBJtZ98//xzN7ChrdNIn1oYdrlWvNBwUqbUY8EihQsHdd9Kn3ogD4oWJ11sfdkV/Iw8Fc54xL8bcJ4XzvWMJLu4rqt8RK03vhESfWx1Ti1Rn272CXs8mFfazVOZzJfzUWKeDvPGdfYhTv6eo4BR+ES34TknY/Zvq3yQNvDzgdteZIzNgxaTINmFtc/8ymcvFm6cjgqWzLu72VNTfqdbGas5/Lc2ZETWZEEw9Tki0jsxv1CGnUyO6yj0XP5Ex1SLpnH5eeO64OCtrbji5QexlnzuJbdXY9xBXf3VC7jT0KICfKeLTMXa8EOv6rRmwWTkayK5wOuGcPNgoWl4YI0+wMRZMbJZCbTgbEeasoQzDBkvUyR7oEp1qLEagHW+uM3P+x9/+tvHw2F5y3YYybnMqKTIARCckGkpmaL2VhtQk1ZZwOL5R5qKcJAZK2Inh5JYCsxQxLAP2nHyYQ5t7HqQ2hz8u/f/3jt0V+voMYtNM049m9h47+GWrovoUrO/Ejc/Nhmcmx/Cp4nTE5m/tNhhSt43ccaL7g08KHTNyIo+PRIwWkWfz77duPMd/NLw6LH4qQOuWWFNx+iCRowGhCrs4mEFupqWygS+jyTyiLxHDOf0yI56TX73CiqbsLl0ifSrG9Gofm4a9M137YqUoz5TglhvkoeDB+AjtSktHZgfi8o+hSu7Nz1uKELWMMrwA01uVEMXqgAHteJih+RXBXG5B5VFN5ntTDGfL+E8H5twvkKpbS9WCe3D4QtZ+flUVME1B4nbXlpjjE/qVXUi9ri1CZcrET4uqQP1QhlnaxGKOtkNUJZH67UJlyt3clqhLJOViOUdbIa4VEJYanCfJ3qc0mfwrhitsLobjBIft4cgfywdlnVCKIWAd4X8Pam8Q+jIyjLQPkfV3gKtKsNAAA=";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JScrollPane aboutContent;
    protected java.lang.String aboutText;
    protected java.awt.Color backgroundColor;
    protected javax.swing.JLabel bottomLabel;
    protected java.lang.String bottomText;
    protected javax.swing.JButton close;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected java.lang.String iconPath;
    protected javax.swing.JScrollPane licenseContent;
    protected java.lang.String licenseText;
    protected javax.swing.JTextArea licenseTextArea;
    protected javax.swing.JTabbedPane tabs;
    protected javax.swing.JScrollPane thirdpartyContent;
    protected java.lang.String thirdpartyText;
    protected javax.swing.JTextArea thirdpartyTextArea;
    protected java.lang.String title;
    protected javax.swing.JPanel topPanel;
    private javax.swing.JEditorPane $JEditorPane3;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JPanel $JPanel4;
    private jaxx.runtime.swing.TabInfo $TabInfo5;
    private jaxx.runtime.swing.TabInfo $TabInfo6;
    private jaxx.runtime.swing.TabInfo $TabInfo7;
    private jaxx.runtime.swing.AboutPanel $Table0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($Table0, "$JLabel2.text");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($Table0, "$JLabel2.visible");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($Table0, "$JEditorPane3.text");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($Table0, "licenseTextArea.text");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($Table0, "thirdpartyTextArea.text");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($Table0, "bottomLabel.text");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($Table0, "bottomLabel.visible");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($Table0, "close.action");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($Table0, "$Table0.background");

    /* begin raw body code */
    final Action closeAction = new AbstractAction("close") {
        private static final long serialVersionUID = 1L;
    
        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog container = getParentContainer(JDialog.class);
            if (container != null) {
                container.dispose();
            } else {
                setVisible(false);
            }
        }
    };
    
    
    public void setLicenseFile(String filename) {
        String load = load(filename);
        setLicenseText(load);
    }
    
    public void setThirdpartyFile(String filename) {
        String load = load(filename);
        setThirdpartyText(load);
    }
    
    public void buildTopPanel() {
        // image
        JLabel labelIcon;
        if (iconPath != null) {
            Icon logoIcon = Resource.getIcon(iconPath);
            labelIcon = new JLabel(logoIcon);
        } else {
            labelIcon = new JLabel();
        }
        topPanel.add(labelIcon);
    }
    
    public void init() {
        if (getAboutText() == null) {
            tabs.remove(aboutContent);
        }
        if (getLicenseText() == null) {
            tabs.remove(licenseContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {
    
                @Override
                public void run() {
                    licenseTextArea.setCaretPosition(0);
                }
            });
    
        }
        if (getThirdpartyText() == null) {
            tabs.remove(thirdpartyContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {
    
                @Override
                public void run() {
                    thirdpartyTextArea.setCaretPosition(0);
                }
            });
        }
    }
    
    public void showInDialog(Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, true);
        f.add(this);
        if (iconPath != null) {
            f.setIconImage(SwingUtil.createIcon(iconPath).getImage());
        }
        f.setResizable(false);
        f.setSize(550, 450);
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(close);
        rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", closeAction);
        SwingUtil.center(ui, f);
        f.setVisible(true);
    }
    
    protected String load(String filename) {
        InputStream licenseStream = getClass().getResourceAsStream("/" + filename);
        String result = null;
        try {
            if (licenseStream != null) {
                result = IOUtils.toString(licenseStream);
            }
        } catch (IOException ex) {
           // ignore it
        } finally {
            if (licenseStream != null) {
                try {
                    licenseStream.close();
                } catch (IOException ex) {
                    log.error("could not close file " + filename);
                }
            }
        }
        if (result == null) {
            result = "resource " + filename + " not found";
        }
        return result;
    }
    
    void $afterCompleteSetup() {
        buildTopPanel();
        close.setText(_("aboutframe.ok"));
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public AboutPanel() {
        $initialize();
    }

    public AboutPanel(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$Table0.background".equals($binding)) {
                addPropertyChangeListener("backgroundColor", $DataSource8);
        
        } else if ("$JLabel2.text".equals($binding)) {
                addPropertyChangeListener("title", $DataSource12);
        
        } else if ("$JLabel2.visible".equals($binding)) {
                addPropertyChangeListener("title", $DataSource13);
        
        } else if ("$JEditorPane3.text".equals($binding)) {
                addPropertyChangeListener("aboutText", $DataSource16);
        
        } else if ("licenseTextArea.text".equals($binding)) {
                addPropertyChangeListener("licenseText", $DataSource19);
        
        } else if ("thirdpartyTextArea.text".equals($binding)) {
                addPropertyChangeListener("thirdpartyText", $DataSource22);
        
        } else if ("bottomLabel.text".equals($binding)) {
                addPropertyChangeListener("bottomText", $DataSource25);
        
        } else if ("bottomLabel.visible".equals($binding)) {
                addPropertyChangeListener("bottomText", $DataSource26);
        
        } else if ("close.action".equals($binding)) {
                addPropertyChangeListener("closeAction", $DataSource27);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$Table0.background".equals($dest)) {
            $Table0.setBackground((getBackgroundColor()));
            } else if ("$JLabel2.text".equals($dest)) {
            $JLabel2.setText(_(String.valueOf((SwingUtil.getStringValue(getTitle())))));
            } else if ("$JLabel2.visible".equals($dest)) {
            $JLabel2.setVisible((getTitle() != null));
            } else if ("$JEditorPane3.text".equals($dest)) {
            jaxx.runtime.SwingUtil.setText($JEditorPane3, String.valueOf((SwingUtil.getStringValue(getAboutText()))));
            } else if ("licenseTextArea.text".equals($dest)) {
            jaxx.runtime.SwingUtil.setText(licenseTextArea, String.valueOf((SwingUtil.getStringValue(getLicenseText()))));
            } else if ("thirdpartyTextArea.text".equals($dest)) {
            jaxx.runtime.SwingUtil.setText(thirdpartyTextArea, String.valueOf((SwingUtil.getStringValue(getThirdpartyText()))));
            } else if ("bottomLabel.text".equals($dest)) {
            bottomLabel.setText(_(String.valueOf((SwingUtil.getStringValue(getBottomText())))));
            } else if ("bottomLabel.visible".equals($dest)) {
            bottomLabel.setVisible((getBottomText() != null));
            } else if ("close.action".equals($dest)) {
            close.setAction((closeAction));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$Table0.background".equals($binding)) {
                removePropertyChangeListener("backgroundColor", $DataSource8);
        
        } else if ("$JLabel2.text".equals($binding)) {
                removePropertyChangeListener("title", $DataSource12);
        
        } else if ("$JLabel2.visible".equals($binding)) {
                removePropertyChangeListener("title", $DataSource13);
        
        } else if ("$JEditorPane3.text".equals($binding)) {
                removePropertyChangeListener("aboutText", $DataSource16);
        
        } else if ("licenseTextArea.text".equals($binding)) {
                removePropertyChangeListener("licenseText", $DataSource19);
        
        } else if ("thirdpartyTextArea.text".equals($binding)) {
                removePropertyChangeListener("thirdpartyText", $DataSource22);
        
        } else if ("bottomLabel.text".equals($binding)) {
                removePropertyChangeListener("bottomText", $DataSource25);
        
        } else if ("bottomLabel.visible".equals($binding)) {
                removePropertyChangeListener("bottomText", $DataSource26);
        
        } else if ("close.action".equals($binding)) {
                removePropertyChangeListener("closeAction", $DataSource27);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doHyperlinkUpdate__on__$JEditorPane3(javax.swing.event.HyperlinkEvent event) {
        SwingUtil.openLink(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JScrollPane getAboutContent() {
        return aboutContent;
    }

    public java.lang.String getAboutText() {
        return aboutText;
    }

    public java.awt.Color getBackgroundColor() {
        return backgroundColor;
    }

    public javax.swing.JLabel getBottomLabel() {
        return bottomLabel;
    }

    public java.lang.String getBottomText() {
        return bottomText;
    }

    public javax.swing.JButton getClose() {
        return close;
    }

    public java.lang.String getIconPath() {
        return iconPath;
    }

    public javax.swing.JScrollPane getLicenseContent() {
        return licenseContent;
    }

    public java.lang.String getLicenseText() {
        return licenseText;
    }

    public javax.swing.JTextArea getLicenseTextArea() {
        return licenseTextArea;
    }

    public javax.swing.JTabbedPane getTabs() {
        return tabs;
    }

    public javax.swing.JScrollPane getThirdpartyContent() {
        return thirdpartyContent;
    }

    public java.lang.String getThirdpartyText() {
        return thirdpartyText;
    }

    public javax.swing.JTextArea getThirdpartyTextArea() {
        return thirdpartyTextArea;
    }

    public java.lang.String getTitle() {
        return title;
    }

    public javax.swing.JPanel getTopPanel() {
        return topPanel;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAboutText(java.lang.String newValue) {
        java.lang.String oldValue = this.aboutText;
        this.aboutText = newValue;
        firePropertyChange("aboutText", oldValue, newValue);
    }

    public void setBackgroundColor(java.awt.Color newValue) {
        java.awt.Color oldValue = this.backgroundColor;
        this.backgroundColor = newValue;
        firePropertyChange("backgroundColor", oldValue, newValue);
    }

    public void setBottomText(java.lang.String newValue) {
        java.lang.String oldValue = this.bottomText;
        this.bottomText = newValue;
        firePropertyChange("bottomText", oldValue, newValue);
    }

    public void setIconPath(java.lang.String newValue) {
        java.lang.String oldValue = this.iconPath;
        this.iconPath = newValue;
        firePropertyChange("iconPath", oldValue, newValue);
    }

    public void setLicenseText(java.lang.String newValue) {
        java.lang.String oldValue = this.licenseText;
        this.licenseText = newValue;
        firePropertyChange("licenseText", oldValue, newValue);
    }

    public void setThirdpartyText(java.lang.String newValue) {
        java.lang.String oldValue = this.thirdpartyText;
        this.thirdpartyText = newValue;
        firePropertyChange("thirdpartyText", oldValue, newValue);
    }

    public void setTitle(java.lang.String newValue) {
        java.lang.String oldValue = this.title;
        this.title = newValue;
        firePropertyChange("title", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JEditorPane get$JEditorPane3() {
        return $JEditorPane3;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo7() {
        return $TabInfo7;
    }

    protected jaxx.runtime.swing.AboutPanel get$Table0() {
        return $Table0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $Table0.add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        $Table0.add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        $Table0.add(tabs, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        $Table0.add($JPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        
        $JPanel1.add($JLabel2, BorderLayout.CENTER);
        
        
        addChildrenToTabs();
        addChildrenToAboutContent();
        
        addChildrenToLicenseContent();
        addChildrenToThirdpartyContent();
        $JPanel4.add(bottomLabel, BorderLayout.CENTER);
        $JPanel4.add(close, BorderLayout.EAST);
        
        
        
        
        applyDataBinding("$Table0.background");
        $Table0.setBorder((BorderFactory.createLineBorder(Color.BLACK, 1)));
        $JPanel1.setBackground((Color.WHITE));
        applyDataBinding("$JLabel2.text");
        applyDataBinding("$JLabel2.visible");
        aboutContent.setBorder((null));
        $JEditorPane3.setBorder((null));
        applyDataBinding("$JEditorPane3.text");
        licenseContent.setBorder((null));
        licenseTextArea.setBorder((null));
        applyDataBinding("licenseTextArea.text");
        thirdpartyContent.setBorder((null));
        thirdpartyTextArea.setBorder((null));
        applyDataBinding("thirdpartyTextArea.text");
        bottomLabel.setHorizontalAlignment((SwingConstants.CENTER));
        applyDataBinding("bottomLabel.text");
        applyDataBinding("bottomLabel.visible");
        applyDataBinding("close.action");
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createTitle();
        createIconPath();
        createAboutText();
        createBottomText();
        createLicenseText();
        createThirdpartyText();
        createBackgroundColor();
        
        $JPanel1 = new javax.swing.JPanel();
        $objectMap.put("$JPanel1", $JPanel1);
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout((new BorderLayout()));
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        if ($JLabel2.getFont() != null) $JLabel2.setFont($JLabel2.getFont().deriveFont((float) 12));
        
        createTopPanel();
        createTabs();
        createAboutContent();
        create$JEditorPane3();
        createLicenseContent();
        createLicenseTextArea();
        createThirdpartyContent();
        createThirdpartyTextArea();
        
        $JPanel4 = new javax.swing.JPanel();
        $objectMap.put("$JPanel4", $JPanel4);
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout((new BorderLayout()));
        
        createBottomLabel();
        createClose();
        
        $TabInfo5 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo5", $TabInfo5);
        $TabInfo5.setTitle(_("aboutframe.about"));
        
        $TabInfo6 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo6", $TabInfo6);
        $TabInfo6.setTitle(_("aboutframe.license"));
        
        $TabInfo7 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo7", $TabInfo7);
        $TabInfo7.setTitle(_("aboutframe.thirdparty"));
        
        $Table0.setName("$Table0");
        
        
        $completeSetup();
    }

    protected void addChildrenToAboutContent() {
        if (!allComponentsCreated) {
            return;
        }
        aboutContent.getViewport().add($JEditorPane3);
    }

    protected void addChildrenToLicenseContent() {
        if (!allComponentsCreated) {
            return;
        }
        licenseContent.getViewport().add(licenseTextArea);
    }

    protected void addChildrenToTabs() {
        if (!allComponentsCreated) {
            return;
        }
        tabs.add(aboutContent);
        tabs.add(licenseContent);
        tabs.add(thirdpartyContent);
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 0));
        tabs.setTitleAt(0, _("aboutframe.about"));
        $TabInfo6.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 1));
        tabs.setTitleAt(1, _("aboutframe.license"));
        $TabInfo7.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 2));
        tabs.setTitleAt(2, _("aboutframe.thirdparty"));
    }

    protected void addChildrenToThirdpartyContent() {
        if (!allComponentsCreated) {
            return;
        }
        thirdpartyContent.getViewport().add(thirdpartyTextArea);
    }

    protected void create$JEditorPane3() {
        $JEditorPane3 = new javax.swing.JEditorPane();
        $objectMap.put("$JEditorPane3", $JEditorPane3);
        $JEditorPane3.setName("$JEditorPane3");
        $JEditorPane3.setContentType("text/html");
        $JEditorPane3.setEditable(false);
        $JEditorPane3.addHyperlinkListener((javax.swing.event.HyperlinkListener) jaxx.runtime.Util.getEventListener(javax.swing.event.HyperlinkListener.class, "hyperlinkUpdate", $Table0, "doHyperlinkUpdate__on__$JEditorPane3"));
    }

    protected void createAboutContent() {
        aboutContent = new javax.swing.JScrollPane();
        $objectMap.put("aboutContent", aboutContent);
        aboutContent.setName("aboutContent");
    }

    protected void createAboutText() {
        aboutText = null;
        $objectMap.put("aboutText", aboutText);
    }

    protected void createBackgroundColor() {
        backgroundColor = null;
        $objectMap.put("backgroundColor", backgroundColor);
    }

    protected void createBottomLabel() {
        bottomLabel = new javax.swing.JLabel();
        $objectMap.put("bottomLabel", bottomLabel);
        bottomLabel.setName("bottomLabel");
    }

    protected void createBottomText() {
        bottomText = null;
        $objectMap.put("bottomText", bottomText);
    }

    protected void createClose() {
        close = new javax.swing.JButton();
        $objectMap.put("close", close);
        close.setName("close");
    }

    protected void createIconPath() {
        iconPath = null;
        $objectMap.put("iconPath", iconPath);
    }

    protected void createLicenseContent() {
        licenseContent = new javax.swing.JScrollPane();
        $objectMap.put("licenseContent", licenseContent);
        licenseContent.setName("licenseContent");
    }

    protected void createLicenseText() {
        licenseText = null;
        $objectMap.put("licenseText", licenseText);
    }

    protected void createLicenseTextArea() {
        licenseTextArea = new javax.swing.JTextArea();
        $objectMap.put("licenseTextArea", licenseTextArea);
        licenseTextArea.setName("licenseTextArea");
        licenseTextArea.setColumns(15);
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setWrapStyleWord(true);
        licenseTextArea.setEditable(false);
        if (licenseTextArea.getFont() != null) licenseTextArea.setFont(licenseTextArea.getFont().deriveFont((float) 11));
    }

    protected void createTabs() {
        tabs = new javax.swing.JTabbedPane();
        $objectMap.put("tabs", tabs);
        tabs.setName("tabs");
    }

    protected void createThirdpartyContent() {
        thirdpartyContent = new javax.swing.JScrollPane();
        $objectMap.put("thirdpartyContent", thirdpartyContent);
        thirdpartyContent.setName("thirdpartyContent");
    }

    protected void createThirdpartyText() {
        thirdpartyText = null;
        $objectMap.put("thirdpartyText", thirdpartyText);
    }

    protected void createThirdpartyTextArea() {
        thirdpartyTextArea = new javax.swing.JTextArea();
        $objectMap.put("thirdpartyTextArea", thirdpartyTextArea);
        thirdpartyTextArea.setName("thirdpartyTextArea");
        thirdpartyTextArea.setColumns(15);
        thirdpartyTextArea.setLineWrap(true);
        thirdpartyTextArea.setWrapStyleWord(true);
        thirdpartyTextArea.setEditable(false);
        if (thirdpartyTextArea.getFont() != null) thirdpartyTextArea.setFont(thirdpartyTextArea.getFont().deriveFont((float) 11));
    }

    protected void createTitle() {
        title = null;
        $objectMap.put("title", title);
    }

    protected void createTopPanel() {
        topPanel = new javax.swing.JPanel();
        $objectMap.put("topPanel", topPanel);
        topPanel.setName("topPanel");
    }

}
