/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberEditorHandler {
    public static final Log log = LogFactory.getLog(NumberEditorHandler.class);
    public static final String BEAN_PROPERTY = "bean";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String MODEL_PROPERTY = "model";
    public static final String AUTO_POPUP_PROPERTY = "autoPopup";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    public static final String USE_SIGN_PROPERTY = "useSign";
    public static final String VALIDATE_PROPERTY = "validate";
    protected NumberEditor editor;
    protected Method mutator;
    protected Method getter;
    protected Boolean acceptNull;

    public NumberEditorHandler(NumberEditor ui) {
        this.editor = ui;
    }

    public void init() {
        try {
            if (this.editor.getBean() == null) {
                throw new NullPointerException("can not have a null bean in ui " + this.editor);
            }
            this.editor.addPropertyChangeListener(MODEL_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("set new model " + evt.getNewValue() + " for " + NumberEditorHandler.this.editor.getProperty()));
                    }
                    NumberEditorHandler.this.setModel((Number)evt.getOldValue(), (Number)evt.getNewValue());
                }
            });
            this.editor.addPropertyChangeListener(POPUP_VISIBLE_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    NumberEditorHandler.this.setPopupVisible((Boolean)evt.getNewValue());
                }
            });
            this.editor.getTextField().addMouseListener(new PopupListener());
            Class<?> type = this.getGetter().getReturnType();
            this.editor.setUseFloat(!type.equals(Integer.class) && !type.equals(Integer.TYPE));
            if (this.editor.getModel() == null) {
                Number num = (Number)this.getGetter().invoke(this.editor.getBean(), new Object[0]);
                this.editor.setModel(num);
            }
        }
        catch (IllegalAccessException ex) {
            log.error((Object)ex);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)ex);
        }
        catch (InvocationTargetException ex) {
            log.error((Object)ex);
        }
    }

    public void setPopupVisible(Boolean newValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)newValue);
        }
        if (newValue == null || !newValue.booleanValue()) {
            this.editor.getPopup().setVisible(false);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JToggleButton invoker = NumberEditorHandler.this.editor.getButton();
                Dimension dim = NumberEditorHandler.this.editor.getPopup().getPreferredSize();
                NumberEditorHandler.this.editor.getPopup().show(invoker, (int)(invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
                NumberEditorHandler.this.editor.getTextField().requestFocus();
            }
        });
    }

    public void setModel(String s) {
        String text = this.editor.getModelText();
        if (text.equals(s)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"modelText is the same, skip !");
            }
            return;
        }
        boolean canApply = false;
        boolean endWithDot = false;
        boolean isLess = false;
        Number newValue = null;
        if (s.trim().isEmpty()) {
            s = null;
            canApply = true;
        } else if (s.endsWith(".")) {
            s = s + "0";
            endWithDot = true;
        } else if (this.editor.isUseSign().booleanValue() && s.length() == 1 && s.startsWith("-")) {
            s = "0";
            isLess = true;
        }
        if (s != null && NumberUtils.isNumber((String)s)) {
            try {
                Float f = Float.valueOf(Float.parseFloat(s));
                if (!this.editor.isUseSign().booleanValue() && s.startsWith("-")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("will skip since can not allow sign on this editor but was " + f));
                    }
                } else if (!this.editor.isUseFloat().booleanValue() && s.contains(".")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("will skip since can not allow float on this editor but was " + f));
                    }
                } else {
                    newValue = this.editor.isUseFloat() != false ? (Number)f : (Number)f.intValue();
                    canApply = true;
                }
            }
            catch (NumberFormatException e) {
                log.debug((Object)e);
            }
        }
        JTextField field = this.editor.getTextField();
        int oldPosition = field.getCaretPosition();
        if (canApply) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("can apply new model value : " + newValue));
            }
            if (isLess) {
                this.editor.setModelText("-");
                return;
            }
            this.editor.setModel(newValue);
            if (endWithDot) {
                this.editor.setModelText(s.substring(0, s.length() - 1));
                field.setCaretPosition(oldPosition);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("invalid text " + s + " reput old text " + text));
        }
        if (oldPosition > 0) {
            --oldPosition;
        }
        field.setText(text);
        try {
            field.setCaretPosition(oldPosition);
        }
        catch (IllegalArgumentException ex) {
            log.debug((Object)("CaretPosition is invalid for position : " + oldPosition), (Throwable)ex);
        }
    }

    public void addChar(String s) {
        char c = s.charAt(0);
        try {
            this.editor.getTextField().getDocument().insertString(this.editor.getTextField().getCaretPosition(), c + "", null);
            this.setModel(this.editor.getTextField().getText());
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
    }

    public void removeChar() {
        String s = this.editor.getModelText();
        int position = this.editor.getTextField().getCaretPosition();
        if (position < 1 || s.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"cannot remove when caret on first position or text empty");
            }
            return;
        }
        try {
            this.editor.getTextField().getDocument().remove(position - 1, 1);
        }
        catch (BadLocationException ex) {
            log.debug((Object)ex);
            return;
        }
        String newText = this.editor.getTextField().getText();
        if (log.isDebugEnabled()) {
            log.debug((Object)("text updated : " + newText));
        }
        this.editor.getTextField().setCaretPosition(--position);
        this.setModel(newText);
    }

    public void toggleSign() {
        String newValue = this.editor.getModelText();
        if (newValue.startsWith("-")) {
            this.setModel(newValue.substring(1));
        } else {
            this.setModel("-" + newValue);
        }
    }

    public NumberEditor getEditor() {
        return this.editor;
    }

    protected void setModel(Number oldValue, Number newValue) {
        if (this.editor.getBean() == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.editor.getProperty() + " on " + this.editor.getBean().getClass() + " :: " + oldValue + " to " + newValue));
        }
        try {
            String strValue;
            if (newValue == null && !this.getAcceptNull().booleanValue()) {
                if (this.editor.isUseFloat().booleanValue()) {
                    this.getMutator().invoke(this.editor.getBean(), Float.valueOf(0.0f));
                } else {
                    this.getMutator().invoke(this.editor.getBean(), 0);
                }
            } else {
                this.getMutator().invoke(this.editor.getBean(), newValue);
            }
            if (newValue == null) {
                strValue = "";
            } else {
                Float n;
                strValue = newValue + "";
                if (this.editor.isUseFloat().booleanValue() && (float)(n = Float.valueOf(Float.parseFloat(strValue))).intValue() == n.floatValue()) {
                    strValue = n.intValue() + "";
                }
            }
            this.editor.setModelText(strValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void validate() {
        this.setPopupVisible(false);
        this.editor.firePropertyChange(VALIDATE_PROPERTY, null, (Object)true);
    }

    protected Method getMutator() {
        if (this.mutator == null) {
            Object bean = this.editor.getBean();
            if (bean == null) {
                throw new NullPointerException("could not find bean in " + this.editor);
            }
            String property = this.editor.getProperty();
            if (property == null) {
                throw new NullPointerException("could not find property in " + this.editor);
            }
            try {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)property);
                this.mutator = descriptor.getWriteMethod();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.mutator;
    }

    protected Method getGetter() {
        if (this.getter == null) {
            Object bean = this.editor.getBean();
            if (bean == null) {
                throw new NullPointerException("could not find bean in " + this.editor);
            }
            String property = this.editor.getProperty();
            if (property == null) {
                throw new NullPointerException("could not find property in " + this.editor);
            }
            try {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)property);
                this.getter = descriptor.getReadMethod();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getter;
    }

    public Boolean getAcceptNull() {
        if (this.acceptNull == null) {
            Method m = this.getMutator();
            if (m == null) {
                throw new IllegalStateException("could not find the mutator");
            }
            Class<?> returnType = m.getParameterTypes()[0];
            this.acceptNull = !returnType.isPrimitive();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.acceptNull + " for mutator " + m.getName() + " type : " + returnType));
            }
        }
        return this.acceptNull;
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (NumberEditorHandler.this.editor.isAutoPopup().booleanValue()) {
                if (NumberEditorHandler.this.editor.isPopupVisible().booleanValue()) {
                    if (!NumberEditorHandler.this.editor.getPopup().isVisible()) {
                        NumberEditorHandler.this.setPopupVisible(true);
                    }
                } else {
                    NumberEditorHandler.this.editor.setPopupVisible(true);
                }
            } else if (NumberEditorHandler.this.editor.isPopupVisible().booleanValue()) {
                NumberEditorHandler.this.setPopupVisible(true);
            }
        }
    }
}

